/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.api.Position;
import de.ellpeck.actuallyadditions.mod.blocks.BlockColoredLamp;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockBase;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockLampPowerer
extends BlockBase {
    @SideOnly(value=Side.CLIENT)
    private IIcon frontIcon;

    public BlockLampPowerer(String name) {
        super(Material.field_151576_e, name);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(field_149769_e);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        if (side == meta) {
            return this.frontIcon;
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 3) {
            return this.frontIcon;
        }
        return this.field_149761_L;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.updateLamp(world, x, y, z);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.updateLamp(world, x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int rotation = BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)player);
        world.func_72921_c(x, y, z, rotation, 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconReg) {
        this.field_149761_L = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":" + this.getBaseName());
        this.frontIcon = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":" + this.getBaseName() + "Front");
    }

    private void updateLamp(World world, int x, int y, int z) {
        Position coords;
        if (!world.field_72995_K && (coords = WorldUtil.getCoordsFromSide(ForgeDirection.getOrientation((int)world.func_72805_g(x, y, z)), x, y, z, 0)) != null && coords.getBlock(world) instanceof BlockColoredLamp) {
            if (world.func_72864_z(x, y, z)) {
                if (!((BlockColoredLamp)coords.getBlock((World)world)).isOn) {
                    world.func_147465_d(coords.getX(), coords.getY(), coords.getZ(), InitBlocks.blockColoredLampOn, world.func_72805_g(coords.getX(), coords.getY(), coords.getZ()), 2);
                }
            } else if (((BlockColoredLamp)coords.getBlock((World)world)).isOn) {
                world.func_147465_d(coords.getX(), coords.getY(), coords.getZ(), InitBlocks.blockColoredLamp, world.func_72805_g(coords.getX(), coords.getY(), coords.getZ()), 2);
            }
        }
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.rare;
    }
}

