/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.booklet;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.booklet.BookletPage;
import de.ellpeck.actuallyadditions.api.booklet.IBookletChapter;
import de.ellpeck.actuallyadditions.api.booklet.IBookletEntry;
import de.ellpeck.actuallyadditions.mod.achievement.InitAchievements;
import de.ellpeck.actuallyadditions.mod.booklet.GuiBooklet;
import de.ellpeck.actuallyadditions.mod.booklet.InitBooklet;
import de.ellpeck.actuallyadditions.mod.booklet.button.BookmarkButton;
import de.ellpeck.actuallyadditions.mod.booklet.button.IndexButton;
import de.ellpeck.actuallyadditions.mod.booklet.button.TexturedButton;
import de.ellpeck.actuallyadditions.mod.booklet.entry.BookletEntryAllSearch;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.KeyUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.awt.Desktop;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.EnumChatFormatting;

public class BookletUtils {
    public static void openBrowser(String url) {
        BookletUtils.openBrowser(url, url);
    }

    public static void openBrowser(String url, String shiftUrl) {
        try {
            if (Desktop.isDesktopSupported()) {
                if (shiftUrl.equals(url) || KeyUtil.isShiftPressed()) {
                    Desktop.getDesktop().browse(new URI(shiftUrl));
                } else {
                    Desktop.getDesktop().browse(new URI(url));
                }
            }
        }
        catch (Exception e) {
            ModUtil.LOGGER.error("Something bad happened when trying to open a URL!", (Throwable)e);
        }
    }

    public static void drawTitle(GuiBooklet booklet) {
        String strg;
        booklet.field_146297_k.func_110434_K().func_110577_a(GuiBooklet.resLoc);
        booklet.func_73729_b(booklet.guiLeft + booklet.xSize / 2 - 71, booklet.guiTop - 12, 0, 240, 142, 12);
        booklet.func_73729_b(booklet.guiLeft + booklet.xSize / 2 - 71, booklet.guiTop + booklet.ySize, 0, 243, 142, 13);
        if (booklet.currentEntrySet.entry == null) {
            strg = EnumChatFormatting.DARK_GREEN + StringUtil.localize("info." + ModUtil.MOD_ID_LOWER + ".booklet.manualName.1");
            booklet.getFontRenderer().func_78276_b(strg, booklet.guiLeft + booklet.xSize / 2 - booklet.getFontRenderer().func_78256_a(strg) / 2 - 3, booklet.guiTop + 12, 0);
            strg = EnumChatFormatting.DARK_GREEN + StringUtil.localize("info." + ModUtil.MOD_ID_LOWER + ".booklet.manualName.2");
            booklet.getFontRenderer().func_78276_b(strg, booklet.guiLeft + booklet.xSize / 2 - booklet.getFontRenderer().func_78256_a(strg) / 2 - 3, booklet.guiTop + 12 + booklet.getFontRenderer().field_78288_b, 0);
            String playerName = Minecraft.func_71410_x().field_71439_g.func_70005_c_();
            String version = playerName.equals("dqmhose") ? "Pants Edition" : (playerName.equals("TwoOfEight") ? "Illustrator's Edition" : (playerName.equals("KittyVanCat") ? "Cat's Edition" : (playerName.equals("Ellpeck") || Util.isDevVersion() ? "Dev's Edition" : StringUtil.localize("info." + ModUtil.MOD_ID_LOWER + ".booklet.edition") + " " + "1.7.10-r21".substring("1.7.10-r21".indexOf("r") + 1))));
            strg = EnumChatFormatting.GOLD + EnumChatFormatting.ITALIC.toString() + "-" + version + "-";
            booklet.getFontRenderer().func_78276_b(strg, booklet.guiLeft + booklet.xSize / 2 - booklet.getFontRenderer().func_78256_a(strg) / 2 - 3, booklet.guiTop + 33, 0);
        }
        strg = booklet.currentEntrySet.chapter == null ? (booklet.currentEntrySet.entry == null ? StringUtil.localize("itemGroup." + ModUtil.MOD_ID_LOWER) : booklet.currentEntrySet.entry.getLocalizedName()) : booklet.currentEntrySet.chapter.getLocalizedName();
        booklet.func_73732_a(booklet.getFontRenderer(), strg, booklet.guiLeft + booklet.xSize / 2, booklet.guiTop - 9, 0xFFFFFF);
    }

    public static void drawAchievementInfo(GuiBooklet booklet, boolean pre, int mouseX, int mouseY) {
        if (booklet.currentEntrySet.chapter == null) {
            return;
        }
        ArrayList<String> infoList = null;
        for (BookletPage page : booklet.currentEntrySet.chapter.getPages()) {
            if (page == null || page.getItemStacksForPage() == null) continue;
            for (ItemStack stack : page.getItemStacksForPage()) {
                if (stack == null) continue;
                for (Achievement achievement : InitAchievements.achievementList) {
                    if (achievement.field_75990_d == null || !ItemUtil.areItemsEqual(stack, achievement.field_75990_d, true)) continue;
                    if (pre) {
                        booklet.field_146297_k.func_110434_K().func_110577_a(GuiBooklet.resLoc);
                        booklet.func_73729_b(booklet.guiLeft + booklet.xSize + 1, booklet.guiTop - 18, 166, 154, 22, 21);
                        return;
                    }
                    if (mouseX < booklet.guiLeft + booklet.xSize + 1 || mouseX >= booklet.guiLeft + booklet.xSize + 1 + 22 || mouseY < booklet.guiTop - 18 || mouseY >= booklet.guiTop - 18 + 21) continue;
                    if (infoList == null) {
                        infoList = new ArrayList<String>();
                        infoList.add(EnumChatFormatting.GOLD + "Achievements related to this chapter:");
                    }
                    infoList.add("-" + StringUtil.localize(achievement.field_75975_e));
                    infoList.add(EnumChatFormatting.GRAY + "(" + achievement.func_75989_e() + ")");
                }
            }
        }
        if (infoList != null) {
            booklet.drawHoveringText(infoList, mouseX, mouseY);
        }
    }

    public static void renderPre(GuiBooklet booklet, int mouseX, int mouseY, int ticksElapsed, boolean mousePressed) {
        if (booklet.currentEntrySet.entry != null) {
            if (booklet.currentEntrySet.chapter != null && booklet.currentEntrySet.page != null) {
                booklet.func_73732_a(booklet.getFontRenderer(), booklet.currentEntrySet.page.getID() + "/" + booklet.currentEntrySet.chapter.getPages().length, booklet.guiLeft + booklet.xSize / 2, booklet.guiTop + 172, 0xFFFFFF);
                booklet.currentEntrySet.page.renderPre(booklet, mouseX, mouseY, ticksElapsed, mousePressed);
            } else {
                booklet.func_73732_a(booklet.getFontRenderer(), booklet.currentEntrySet.pageInIndex + "/" + booklet.indexPageAmount, booklet.guiLeft + booklet.xSize / 2, booklet.guiTop + 172, 0xFFFFFF);
            }
        } else {
            String wordCountString = StringUtil.localizeFormatted("booklet." + ModUtil.MOD_ID_LOWER + ".amountOfWords", InitBooklet.wordCount);
            booklet.getFontRenderer().func_78276_b(EnumChatFormatting.ITALIC + wordCountString, booklet.guiLeft + booklet.xSize - booklet.getFontRenderer().func_78256_a(wordCountString) - 15, booklet.guiTop + booklet.ySize - 18 - booklet.getFontRenderer().field_78288_b, 0);
            String charCountString = StringUtil.localizeFormatted("booklet." + ModUtil.MOD_ID_LOWER + ".amountOfChars", InitBooklet.charCount);
            booklet.getFontRenderer().func_78276_b(EnumChatFormatting.ITALIC + charCountString, booklet.guiLeft + booklet.xSize - booklet.getFontRenderer().func_78256_a(charCountString) - 15, booklet.guiTop + booklet.ySize - 18, 0);
        }
    }

    public static void doHoverTexts(GuiBooklet booklet, int mouseX, int mouseY) {
        for (Object button : booklet.getButtonList()) {
            if (!(button instanceof GuiButton) || !((GuiButton)button).field_146125_m || !((GuiButton)button).func_146115_a()) continue;
            if (button instanceof BookmarkButton) {
                ((BookmarkButton)((Object)button)).drawHover(mouseX, mouseY);
                continue;
            }
            if (!(button instanceof TexturedButton)) continue;
            booklet.drawHoveringText(((TexturedButton)((Object)button)).textList, mouseX, mouseY);
        }
    }

    public static void updateSearchBar(GuiBooklet booklet) {
        if (booklet.currentEntrySet.entry instanceof BookletEntryAllSearch) {
            BookletEntryAllSearch currentEntry = (BookletEntryAllSearch)booklet.currentEntrySet.entry;
            if (booklet.searchField.func_146179_b() != null && !booklet.searchField.func_146179_b().isEmpty()) {
                currentEntry.chapters.clear();
                for (IBookletChapter chapter : currentEntry.allChapters) {
                    if (!chapter.getLocalizedName().toLowerCase(Locale.ROOT).contains(booklet.searchField.func_146179_b().toLowerCase(Locale.ROOT))) continue;
                    currentEntry.chapters.add(chapter);
                }
            } else {
                currentEntry.setChapters((ArrayList)currentEntry.allChapters.clone());
            }
            BookletUtils.openIndexEntry(booklet, booklet.currentEntrySet.entry, booklet.currentEntrySet.pageInIndex, false);
        }
    }

    public static void openIndexEntry(GuiBooklet booklet, IBookletEntry entry, int page, boolean resetTextField) {
        booklet.searchField.func_146189_e(entry instanceof BookletEntryAllSearch);
        booklet.searchField.func_146195_b(entry instanceof BookletEntryAllSearch);
        if (resetTextField) {
            booklet.searchField.func_146180_a("");
            if (entry instanceof BookletEntryAllSearch) {
                entry.setChapters((List)((BookletEntryAllSearch)entry).allChapters.clone());
            }
        }
        booklet.currentEntrySet.page = null;
        booklet.currentEntrySet.chapter = null;
        booklet.currentEntrySet.entry = entry;
        booklet.indexPageAmount = entry == null ? 1 : entry.getChapters().size() / booklet.chapterButtons.length + 1;
        booklet.currentEntrySet.pageInIndex = entry == null ? 1 : (booklet.indexPageAmount <= page || page <= 0 ? booklet.indexPageAmount : page);
        booklet.buttonPreviousScreen.field_146125_m = entry != null;
        booklet.buttonForward.field_146125_m = booklet.currentEntrySet.pageInIndex < booklet.indexPageAmount;
        booklet.buttonBackward.field_146125_m = booklet.currentEntrySet.pageInIndex > 1;
        for (int i = 0; i < booklet.chapterButtons.length; ++i) {
            boolean entryExists;
            IndexButton button = (IndexButton)booklet.chapterButtons[i];
            if (entry == null) {
                if (i >= 3) {
                    button.field_146125_m = entryExists = ActuallyAdditionsAPI.bookletEntries.size() > i - 3;
                    if (!entryExists) continue;
                    button.field_146126_j = ActuallyAdditionsAPI.bookletEntries.get(i - 3).getLocalizedNameWithFormatting();
                    button.chap = null;
                    continue;
                }
                button.field_146125_m = false;
                continue;
            }
            button.field_146125_m = entryExists = entry.getChapters().size() > i + (booklet.chapterButtons.length * booklet.currentEntrySet.pageInIndex - booklet.chapterButtons.length);
            if (!entryExists) continue;
            IBookletChapter chap = entry.getChapters().get(i + (booklet.chapterButtons.length * booklet.currentEntrySet.pageInIndex - booklet.chapterButtons.length));
            button.field_146126_j = chap.getLocalizedNameWithFormatting();
            button.chap = chap;
        }
    }

    public static void handleChapterButtonClick(GuiBooklet booklet, GuiButton button) {
        int place = Util.arrayContains(booklet.chapterButtons, button);
        if (place >= 0) {
            if (booklet.currentEntrySet.entry != null) {
                if (booklet.currentEntrySet.chapter == null && place < booklet.currentEntrySet.entry.getChapters().size()) {
                    IBookletChapter chap = booklet.currentEntrySet.entry.getChapters().get(place + (booklet.chapterButtons.length * booklet.currentEntrySet.pageInIndex - booklet.chapterButtons.length));
                    BookletUtils.openChapter(booklet, chap, chap.getPages()[0]);
                }
            } else if (place - 3 < ActuallyAdditionsAPI.bookletEntries.size()) {
                BookletUtils.openIndexEntry(booklet, ActuallyAdditionsAPI.bookletEntries.get(place - 3), 1, true);
            }
        }
    }

    public static void openChapter(GuiBooklet booklet, IBookletChapter chapter, BookletPage page) {
        if (chapter == null || booklet.currentEntrySet.entry == null) {
            return;
        }
        booklet.searchField.func_146189_e(false);
        booklet.searchField.func_146195_b(false);
        booklet.searchField.func_146180_a("");
        booklet.currentEntrySet.chapter = chapter;
        booklet.currentEntrySet.page = page != null && BookletUtils.doesChapterHavePage(chapter, page) ? page : chapter.getPages()[0];
        booklet.buttonForward.field_146125_m = BookletUtils.getNextPage(chapter, booklet.currentEntrySet.page) != null;
        booklet.buttonBackward.field_146125_m = BookletUtils.getPrevPage(chapter, booklet.currentEntrySet.page) != null;
        booklet.buttonPreviousScreen.field_146125_m = true;
        for (GuiButton chapterButton : booklet.chapterButtons) {
            chapterButton.field_146125_m = false;
        }
    }

    private static boolean doesChapterHavePage(IBookletChapter chapter, BookletPage page) {
        for (BookletPage aPage : chapter.getPages()) {
            if (aPage != page) continue;
            return true;
        }
        return false;
    }

    private static BookletPage getNextPage(IBookletChapter chapter, BookletPage page) {
        for (int i = 0; i < chapter.getPages().length; ++i) {
            if (chapter.getPages()[i] != page || i + 1 >= chapter.getPages().length) continue;
            return chapter.getPages()[i + 1];
        }
        return null;
    }

    private static BookletPage getPrevPage(IBookletChapter chapter, BookletPage page) {
        for (int i = 0; i < chapter.getPages().length; ++i) {
            if (chapter.getPages()[i] != page || i - 1 < 0) continue;
            return chapter.getPages()[i - 1];
        }
        return null;
    }

    public static void handleNextPage(GuiBooklet booklet) {
        if (booklet.currentEntrySet.entry != null) {
            if (booklet.currentEntrySet.page != null) {
                BookletPage page = BookletUtils.getNextPage(booklet.currentEntrySet.chapter, booklet.currentEntrySet.page);
                if (page != null) {
                    booklet.currentEntrySet.page = page;
                }
                booklet.buttonForward.field_146125_m = BookletUtils.getNextPage(booklet.currentEntrySet.chapter, booklet.currentEntrySet.page) != null;
                booklet.buttonBackward.field_146125_m = BookletUtils.getPrevPage(booklet.currentEntrySet.chapter, booklet.currentEntrySet.page) != null;
            } else if (booklet.currentEntrySet.pageInIndex + 1 <= booklet.indexPageAmount) {
                BookletUtils.openIndexEntry(booklet, booklet.currentEntrySet.entry, booklet.currentEntrySet.pageInIndex + 1, !(booklet.currentEntrySet.entry instanceof BookletEntryAllSearch));
            }
        }
    }

    public static void handlePreviousPage(GuiBooklet booklet) {
        if (booklet.currentEntrySet.entry != null) {
            if (booklet.currentEntrySet.page != null) {
                BookletPage page = BookletUtils.getPrevPage(booklet.currentEntrySet.chapter, booklet.currentEntrySet.page);
                if (page != null) {
                    booklet.currentEntrySet.page = page;
                }
                booklet.buttonForward.field_146125_m = BookletUtils.getNextPage(booklet.currentEntrySet.chapter, booklet.currentEntrySet.page) != null;
                booklet.buttonBackward.field_146125_m = BookletUtils.getPrevPage(booklet.currentEntrySet.chapter, booklet.currentEntrySet.page) != null;
            } else if (booklet.currentEntrySet.pageInIndex - 1 > 0) {
                BookletUtils.openIndexEntry(booklet, booklet.currentEntrySet.entry, booklet.currentEntrySet.pageInIndex - 1, !(booklet.currentEntrySet.entry instanceof BookletEntryAllSearch));
            }
        }
    }

    public static BookletPage getFirstPageForStack(ItemStack stack) {
        ArrayList<BookletPage> pages = BookletUtils.getPagesForStack(stack);
        return pages.isEmpty() ? null : pages.get(0);
    }

    public static ArrayList<BookletPage> getPagesForStack(ItemStack stack) {
        ArrayList<BookletPage> possiblePages = new ArrayList<BookletPage>();
        for (BookletPage page : ActuallyAdditionsAPI.bookletPagesWithItemStackData) {
            if (!ItemUtil.contains(page.getItemStacksForPage(), stack, page.arePageStacksWildcard)) continue;
            possiblePages.add(page);
        }
        return possiblePages;
    }
}

