/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.event;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.metalists.TheWildPlants;
import de.ellpeck.actuallyadditions.mod.config.ConfigValues;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigIntValues;
import de.ellpeck.actuallyadditions.mod.util.Util;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.biome.BiomeGenOcean;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;

public class WorldDecorationEvent {
    @SubscribeEvent
    public void onWorldDecoration(DecorateBiomeEvent.Decorate event) {
        if (event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DEFAULT) {
            if (Util.arrayContains(ConfigValues.plantDimensionBlacklist, event.world.field_73011_w.field_76574_g) < 0) {
                this.generateRice((DecorateBiomeEvent)event);
                this.genPlantNormally(InitBlocks.blockWildPlant, TheWildPlants.CANOLA.ordinal(), ConfigIntValues.CANOLA_AMOUNT.getValue(), ConfigBoolValues.DO_CANOLA_GEN.isEnabled(), Material.field_151577_b, (DecorateBiomeEvent)event);
                this.genPlantNormally(InitBlocks.blockWildPlant, TheWildPlants.FLAX.ordinal(), ConfigIntValues.FLAX_AMOUNT.getValue(), ConfigBoolValues.DO_FLAX_GEN.isEnabled(), Material.field_151577_b, (DecorateBiomeEvent)event);
                this.genPlantNormally(InitBlocks.blockWildPlant, TheWildPlants.COFFEE.ordinal(), ConfigIntValues.COFFEE_AMOUNT.getValue(), ConfigBoolValues.DO_COFFEE_GEN.isEnabled(), Material.field_151577_b, (DecorateBiomeEvent)event);
                this.genPlantNormally(InitBlocks.blockBlackLotus, 0, ConfigIntValues.BLACK_LOTUS_AMOUNT.getValue(), ConfigBoolValues.DO_LOTUS_GEN.isEnabled(), Material.field_151577_b, (DecorateBiomeEvent)event);
            }
            if (ConfigBoolValues.DO_TREASURE_CHEST_GEN.isEnabled() && event.rand.nextInt(300) == 0) {
                int genX = event.chunkX + event.rand.nextInt(16) + 8;
                int genZ = event.chunkZ + event.rand.nextInt(16) + 8;
                int genY = event.world.func_72825_h(genX, genZ);
                if (event.world.func_72807_a(genX, genZ) instanceof BiomeGenOcean && genY >= 25 && genY <= 45 && event.world.func_147439_a(genX, genY, genZ).func_149688_o() == Material.field_151586_h && event.world.func_147439_a(genX, genY - 1, genZ).func_149688_o().func_76220_a()) {
                    event.world.func_147465_d(genX, genY, genZ, InitBlocks.blockTreasureChest, event.rand.nextInt(4), 2);
                }
            }
        }
    }

    private void generateRice(DecorateBiomeEvent event) {
        if (ConfigBoolValues.DO_RICE_GEN.isEnabled()) {
            for (int i = 0; i < ConfigIntValues.RICE_AMOUNT.getValue(); ++i) {
                int genZ;
                int genY;
                int genX;
                if (event.rand.nextInt(50) != 0 || event.world.func_147439_a(genX = event.chunkX + event.rand.nextInt(16) + 8, genY = event.world.func_72825_h(genX, genZ = event.chunkZ + event.rand.nextInt(16) + 8), genZ).func_149688_o() != Material.field_151586_h) continue;
                ArrayList<Material> blocksAroundBottom = WorldUtil.getMaterialsAround(event.world, genX, genY, genZ);
                ArrayList<Material> blocksAroundTop = WorldUtil.getMaterialsAround(event.world, genX, genY + 1, genZ);
                if (!blocksAroundBottom.contains(Material.field_151577_b) && !blocksAroundBottom.contains(Material.field_151578_c) && !blocksAroundBottom.contains(Material.field_151576_e) && !blocksAroundBottom.contains(Material.field_151595_p) || blocksAroundTop.contains(Material.field_151586_h) || event.world.func_147439_a(genX, genY + 1, genZ).func_149688_o() != Material.field_151579_a) continue;
                event.world.func_147465_d(genX, genY + 1, genZ, InitBlocks.blockWildPlant, TheWildPlants.RICE.ordinal(), 2);
            }
        }
    }

    private void genPlantNormally(Block plant, int meta, int amount, boolean doIt, Material blockBelow, DecorateBiomeEvent event) {
        if (doIt) {
            for (int i = 0; i < amount; ++i) {
                int genZ;
                int genY;
                int genX;
                if (event.rand.nextInt(400) != 0 || event.world.func_147439_a(genX = event.chunkX + event.rand.nextInt(16) + 8, genY = event.world.func_72825_h(genX, genZ = event.chunkZ + event.rand.nextInt(16) + 8) - 1, genZ).func_149688_o() != blockBelow) continue;
                event.world.func_147465_d(genX, genY + 1, genZ, plant, meta, 2);
                if (plant.func_149718_j(event.world, genX, genY + 1, genZ)) continue;
                event.world.func_147468_f(genX, genY + 1, genZ);
            }
        }
    }
}

