/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.gen;

import cpw.mods.fml.common.registry.VillagerRegistry;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigIntValues;
import de.ellpeck.actuallyadditions.mod.gen.JamVillagerTradeHandler;
import de.ellpeck.actuallyadditions.mod.gen.VillageComponentCustomCropField;
import de.ellpeck.actuallyadditions.mod.gen.VillageComponentJamHouse;
import de.ellpeck.actuallyadditions.mod.gen.VillageCustomCropFieldHandler;
import de.ellpeck.actuallyadditions.mod.gen.VillageJamHouseHandler;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheJams;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.ChestGenHooks;

public class InitVillager {
    public static final String JAM_HOUSE_CHEST_NAME = ModUtil.MOD_ID_LOWER + ".jamHouseChest";

    public static void init() {
        ModUtil.LOGGER.info("Initializing Village Addons...");
        if (ConfigBoolValues.JAM_VILLAGER_EXISTS.isEnabled()) {
            InitVillager.initJamVillagePart();
        }
        if (ConfigBoolValues.CROP_FIELD_EXISTS.isEnabled()) {
            InitVillager.initCustomCropFieldPart();
        }
    }

    private static void initJamVillagePart() {
        int jamID = ConfigIntValues.JAM_VILLAGER_ID.getValue();
        VillagerRegistry.instance().registerVillagerId(jamID);
        VillagerRegistry.instance().registerVillageTradeHandler(jamID, (VillagerRegistry.IVillageTradeHandler)new JamVillagerTradeHandler());
        ChestGenHooks jamHouseChest = ChestGenHooks.getInfo((String)JAM_HOUSE_CHEST_NAME);
        jamHouseChest.setMin(5);
        jamHouseChest.setMax(10);
        for (int i = 0; i < TheJams.values().length; ++i) {
            ChestGenHooks.addItem((String)JAM_HOUSE_CHEST_NAME, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(InitItems.itemJams, 1, i), 1, 1, 10));
        }
        ChestGenHooks.addItem((String)JAM_HOUSE_CHEST_NAME, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Items.field_151069_bo), 1, 2, 30));
        ChestGenHooks.addItem((String)JAM_HOUSE_CHEST_NAME, (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack((Item)Items.field_151068_bn), 1, 1, 20));
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageJamHouseHandler());
        MapGenStructureIO.func_143031_a(VillageComponentJamHouse.class, (String)(ModUtil.MOD_ID_LOWER + ":jamHouseStructure"));
    }

    private static void initCustomCropFieldPart() {
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageCustomCropFieldHandler());
        MapGenStructureIO.func_143031_a(VillageComponentCustomCropField.class, (String)(ModUtil.MOD_ID_LOWER + ":customCropFieldStructure"));
    }
}

