/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.api.Position;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemLeafBlower
extends ItemBase {
    private final boolean isAdvanced;

    public ItemLeafBlower(boolean isAdvanced, String name) {
        super(name);
        this.isAdvanced = isAdvanced;
        this.func_77625_d(1);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.bow;
    }

    public int func_77626_a(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.isAdvanced ? EnumRarity.epic : EnumRarity.rare;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconReg) {
        this.field_77791_bV = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":" + this.getBaseName());
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int time) {
        if (!player.field_70170_p.field_72995_K && time <= this.func_77626_a(stack) && (this.isAdvanced || time % 3 == 0)) {
            this.breakStuff(player.field_70170_p, MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v));
            if (ConfigBoolValues.LEAF_BLOWER_SOUND.isEnabled()) {
                player.field_70170_p.func_72956_a((Entity)player, "minecart.base", 0.3f, 0.001f);
            }
        }
    }

    public void breakStuff(World world, int x, int y, int z) {
        ArrayList<Position> breakPositions = new ArrayList<Position>();
        int rangeSides = 5;
        int rangeUp = 1;
        for (int reachX = -rangeSides; reachX < rangeSides + 1; ++reachX) {
            for (int reachZ = -rangeSides; reachZ < rangeSides + 1; ++reachZ) {
                for (int reachY = this.isAdvanced ? -rangeSides : -rangeUp; reachY < (this.isAdvanced ? rangeSides : rangeUp) + 1; ++reachY) {
                    Block block = world.func_147439_a(x + reachX, y + reachY, z + reachZ);
                    if (block == null || !(block instanceof BlockBush) && (!this.isAdvanced || !block.isLeaves((IBlockAccess)world, x + reachX, y + reachY, z + reachZ))) continue;
                    breakPositions.add(new Position(x + reachX, y + reachY, z + reachZ));
                }
            }
        }
        if (!breakPositions.isEmpty()) {
            Collections.shuffle(breakPositions);
            Position theCoord = (Position)breakPositions.get(0);
            Block theBlock = world.func_147439_a(theCoord.getX(), theCoord.getY(), theCoord.getZ());
            ArrayList drops = new ArrayList();
            int meta = world.func_72805_g(theCoord.getX(), theCoord.getY(), theCoord.getZ());
            drops.addAll(theBlock.getDrops(world, theCoord.getX(), theCoord.getY(), theCoord.getZ(), meta, 0));
            world.func_147468_f(theCoord.getX(), theCoord.getY(), theCoord.getZ());
            world.func_72926_e(2001, theCoord.getX(), theCoord.getY(), theCoord.getZ(), Block.func_149682_b((Block)theBlock) + (meta << 12));
            for (ItemStack theDrop : drops) {
                world.func_72838_d((Entity)new EntityItem(world, (double)theCoord.getX() + 0.5, (double)theCoord.getY() + 0.5, (double)theCoord.getZ() + 0.5, theDrop));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        return this.field_77791_bV;
    }
}

