/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items.base;

import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.mod.config.ConfigValues;
import de.ellpeck.actuallyadditions.mod.creative.CreativeTab;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.oredict.OreDictionary;

public class ItemAllToolAA
extends ItemTool {
    @SideOnly(value=Side.CLIENT)
    private IIcon overlayIcon;
    private int color;
    private String name;
    private EnumRarity rarity;
    private ItemStack repairItem;
    private String repairOredict;

    public ItemAllToolAA(Item.ToolMaterial toolMat, ItemStack repairItem, String unlocalizedName, EnumRarity rarity, int color) {
        super(4.0f, toolMat, (Set)Sets.newHashSet());
        this.repairItem = repairItem;
        this.name = unlocalizedName;
        this.rarity = rarity;
        this.color = color;
        this.func_77656_e(this.func_77612_l() * 4);
        this.register();
    }

    public ItemAllToolAA(Item.ToolMaterial toolMat, String repairItem, String unlocalizedName, EnumRarity rarity, int color) {
        this(toolMat, (ItemStack)null, unlocalizedName, rarity, color);
        this.repairOredict = repairItem;
    }

    private void register() {
        this.func_77655_b(ModUtil.MOD_ID_LOWER + "." + this.getBaseName());
        GameRegistry.registerItem((Item)this, (String)this.getBaseName());
        if (this.shouldAddCreative()) {
            this.func_77637_a(CreativeTab.instance);
        } else {
            this.func_77637_a(null);
        }
    }

    protected String getBaseName() {
        return this.name;
    }

    public boolean shouldAddCreative() {
        return true;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!player.func_82247_a(x, y, z, side, stack)) {
            return false;
        }
        UseHoeEvent event = new UseHoeEvent(player, stack, world, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            stack.func_77972_a(1, (EntityLivingBase)player);
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        if (side != 0 && world.func_147439_a(x, y + 1, z).isAir((IBlockAccess)world, x, y + 1, z) && (block == Blocks.field_150349_c || block == Blocks.field_150346_d)) {
            Block block1 = Blocks.field_150458_ak;
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), block1.field_149762_H.func_150498_e(), (block1.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block1.field_149762_H.func_150494_d() * 0.8f);
            if (world.field_72995_K) {
                return true;
            }
            world.func_147449_b(x, y, z, block1);
            stack.func_77972_a(1, (EntityLivingBase)player);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        return pass > 0 ? this.color : super.func_82790_a(stack, pass);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.rarity;
    }

    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int damage, int pass) {
        return pass > 0 ? this.overlayIcon : super.func_77618_c(damage, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconReg) {
        this.field_77791_bV = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":itemPaxel");
        this.overlayIcon = iconReg.func_94245_a(ModUtil.MOD_ID_LOWER + ":itemPaxelOverlay");
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return this.hasExtraWhitelist(block) || block.func_149688_o().func_76229_l() || block == Blocks.field_150431_aC || block == Blocks.field_150433_aE || (block == Blocks.field_150343_Z ? this.field_77862_b.func_77996_d() >= 3 : (block != Blocks.field_150484_ah && block != Blocks.field_150482_ag ? (block != Blocks.field_150412_bA && block != Blocks.field_150475_bE ? (block != Blocks.field_150340_R && block != Blocks.field_150352_o ? (block != Blocks.field_150339_S && block != Blocks.field_150366_p ? (block != Blocks.field_150368_y && block != Blocks.field_150369_x ? (block != Blocks.field_150450_ax && block != Blocks.field_150439_ay ? block.func_149688_o() == Material.field_151576_e || block.func_149688_o() == Material.field_151573_f || block.func_149688_o() == Material.field_151574_g : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 1) : this.field_77862_b.func_77996_d() >= 1) : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 2) : this.field_77862_b.func_77996_d() >= 2));
    }

    private boolean hasExtraWhitelist(Block block) {
        String name = Block.field_149771_c.func_148750_c((Object)block);
        if (name != null) {
            for (String list : ConfigValues.paxelExtraMiningWhitelist) {
                if (!list.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        if (this.repairItem != null) {
            return ItemUtil.areItemsEqual(this.repairItem, stack, false);
        }
        if (this.repairOredict != null) {
            int[] idsStack;
            for (int id : idsStack = OreDictionary.getOreIDs((ItemStack)stack)) {
                if (!OreDictionary.getOreName((int)id).equals(this.repairOredict)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("pickaxe");
        hashSet.add("axe");
        hashSet.add("shovel");
        return hashSet;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        return this.hasExtraWhitelist(block) || block.getHarvestTool(meta) == null || block.getHarvestTool(meta).isEmpty() || this.getToolClasses(stack).contains(block.getHarvestTool(meta)) ? this.field_77864_a : 1.0f;
    }
}

