/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import de.ellpeck.actuallyadditions.api.booklet.BookletPage;
import de.ellpeck.actuallyadditions.api.booklet.INEIRecipeHandler;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.booklet.BookletUtils;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheMiscItems;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.awt.Rectangle;
import java.util.Collections;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class NEICompostRecipe
extends TemplateRecipeHandler
implements INEIRecipeHandler {
    public static final String NAME = "actuallyadditions.compost";

    public NEICompostRecipe() {
        RecipeInfo.setGuiOffset(this.getGuiClass(), (int)0, (int)0);
    }

    @Override
    public BookletPage getPageForInfo(int page) {
        return BookletUtils.getFirstPageForStack(new ItemStack(InitBlocks.blockCompost));
    }

    public String getRecipeName() {
        return StringUtil.localize("container.nei.actuallyadditions.compost.name");
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(63, 18, 22, 16), NAME, new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(NAME) && this.getClass() == NEICompostRecipe.class) {
            this.arecipes.add(new CachedCompostRecipe(new ItemStack(InitItems.itemMisc, 10, TheMiscItems.MASHED_FOOD.ordinal()), new ItemStack(InitItems.itemFertilizer, 10)));
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (NEIServerUtils.areStacksSameType((ItemStack)new ItemStack(InitItems.itemFertilizer), (ItemStack)result)) {
            this.arecipes.add(new CachedCompostRecipe(new ItemStack(InitItems.itemMisc, 10, TheMiscItems.MASHED_FOOD.ordinal()), new ItemStack(InitItems.itemFertilizer, 10)));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (NEIServerUtils.areStacksSameTypeCrafting((ItemStack)new ItemStack(InitItems.itemMisc, 10, TheMiscItems.MASHED_FOOD.ordinal()), (ItemStack)ingredient)) {
            CachedCompostRecipe theRecipe = new CachedCompostRecipe(new ItemStack(InitItems.itemMisc, 10, TheMiscItems.MASHED_FOOD.ordinal()), new ItemStack(InitItems.itemFertilizer, 10));
            theRecipe.setIngredientPermutation(Collections.singletonList(theRecipe.input), ingredient);
            this.arecipes.add(theRecipe);
        }
    }

    public String getGuiTexture() {
        return ModUtil.MOD_ID_LOWER + ":textures/gui/guiNEISimple.png";
    }

    public String getOverlayIdentifier() {
        return NAME;
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return null;
    }

    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)32, (int)0, (int)0, (int)0, (int)96, (int)60);
    }

    public int recipiesPerPage() {
        return 2;
    }

    public class CachedCompostRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack result;
        public PositionedStack input;
        public int chance;

        public CachedCompostRecipe(ItemStack input, ItemStack result) {
            super((TemplateRecipeHandler)NEICompostRecipe.this);
            this.result = new PositionedStack((Object)result, 99, 19);
            this.input = new PositionedStack((Object)input, 37, 19);
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public PositionedStack getIngredient() {
            return this.input;
        }
    }
}

