/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.recipe;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.recipe.CrusherRecipe;
import de.ellpeck.actuallyadditions.mod.config.ConfigValues;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class CrusherRecipeRegistry {
    public static ArrayList<SearchCase> searchCases = new ArrayList();

    public static void registerFinally() {
        ArrayList<String> oresNoResult = new ArrayList<String>();
        int recipeStartedAt = ActuallyAdditionsAPI.crusherRecipes.size();
        block0: for (String ore : OreDictionary.getOreNames()) {
            if (CrusherRecipeRegistry.hasException(ore)) continue;
            for (SearchCase theCase : searchCases) {
                if (ore.length() <= theCase.theCase.length() || !ore.substring(0, theCase.theCase.length()).equals(theCase.theCase)) continue;
                String output = theCase.resultPreString + ore.substring(theCase.theCase.length());
                if (CrusherRecipeRegistry.hasOreRecipe(ore)) continue block0;
                if (!OreDictionary.getOres((String)output, (boolean)false).isEmpty() && !OreDictionary.getOres((String)ore, (boolean)false).isEmpty()) {
                    ActuallyAdditionsAPI.addCrusherRecipe(ore, output, theCase.resultAmount);
                    continue block0;
                }
                oresNoResult.add(ore);
                continue block0;
            }
        }
        ArrayList<String> addedRecipes = new ArrayList<String>();
        for (int i = recipeStartedAt; i < ActuallyAdditionsAPI.crusherRecipes.size(); ++i) {
            CrusherRecipe recipe = ActuallyAdditionsAPI.crusherRecipes.get(i);
            addedRecipes.add(recipe.input + " -> " + recipe.outputOneAmount + "x " + recipe.outputOne);
        }
        ModUtil.LOGGER.info("Added " + addedRecipes.size() + " Crusher Recipes automatically: " + addedRecipes.toString());
        ModUtil.LOGGER.warn("Couldn't add " + oresNoResult.size() + " Crusher Recipes automatically because the inputs were missing outputs: " + oresNoResult.toString());
    }

    private static boolean hasException(String ore) {
        for (String conf : ConfigValues.crusherRecipeExceptions) {
            if (!conf.equals(ore)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOreRecipe(String input) {
        for (CrusherRecipe recipe : ActuallyAdditionsAPI.crusherRecipes) {
            if (recipe.input == null || !recipe.input.equals(input)) continue;
            return true;
        }
        return false;
    }

    public static List<ItemStack> getOutputOnes(ItemStack input) {
        CrusherRecipe recipe = CrusherRecipeRegistry.getRecipeFromInput(input);
        return recipe == null ? null : recipe.getRecipeOutputOnes();
    }

    public static CrusherRecipe getRecipeFromInput(ItemStack input) {
        for (CrusherRecipe recipe : ActuallyAdditionsAPI.crusherRecipes) {
            if (!ItemUtil.contains(recipe.getRecipeInputs(), input, true)) continue;
            return recipe;
        }
        return null;
    }

    public static List<ItemStack> getOutputTwos(ItemStack input) {
        CrusherRecipe recipe = CrusherRecipeRegistry.getRecipeFromInput(input);
        return recipe == null ? null : recipe.getRecipeOutputTwos();
    }

    public static int getOutputTwoChance(ItemStack input) {
        CrusherRecipe recipe = CrusherRecipeRegistry.getRecipeFromInput(input);
        return recipe == null ? -1 : recipe.outputTwoChance;
    }

    public static class SearchCase {
        String theCase;
        int resultAmount;
        String resultPreString;

        public SearchCase(String theCase, int resultAmount) {
            this(theCase, resultAmount, "dust");
        }

        public SearchCase(String theCase, int resultAmount, String resultPreString) {
            this.theCase = theCase;
            this.resultAmount = resultAmount;
            this.resultPreString = resultPreString;
        }
    }
}

