/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.api.recipe.coffee.CoffeeIngredient;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.ItemCoffee;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheMiscItems;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.IEnergySaver;
import de.ellpeck.actuallyadditions.mod.tile.IFluidSaver;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityCoffeeMachine
extends TileEntityInventoryBase
implements IButtonReactor,
IEnergyReceiver,
IFluidSaver,
IFluidHandler,
IEnergySaver {
    public static final int SLOT_COFFEE_BEANS = 0;
    public static final int SLOT_INPUT = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int SLOT_WATER_INPUT = 11;
    public static final int SLOT_WATER_OUTPUT = 12;
    public static final int CACHE_USE = 15;
    public static final int ENERGY_USED = 150;
    public static final int WATER_USE = 500;
    public static final int COFFEE_CACHE_MAX_AMOUNT = 300;
    private static final int TIME_USED = 500;
    public EnergyStorage storage = new EnergyStorage(300000);
    public FluidTank tank = new FluidTank(4000);
    public int coffeeCacheAmount;
    public int brewTime;
    private int lastEnergy;
    private int lastTank;
    private int lastCoffeeAmount;
    private int lastBrewTime;

    public TileEntityCoffeeMachine() {
        super(13, "coffeeMachine");
    }

    @SideOnly(value=Side.CLIENT)
    public int getCoffeeScaled(int i) {
        return this.coffeeCacheAmount * i / 300;
    }

    @SideOnly(value=Side.CLIENT)
    public int getWaterScaled(int i) {
        return this.tank.getFluidAmount() * i / this.tank.getCapacity();
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrewScaled(int i) {
        return this.brewTime * i / 500;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.storeCoffee();
            if (this.brewTime > 0 || this.isRedstonePowered) {
                this.brew();
            }
            if ((this.coffeeCacheAmount != this.lastCoffeeAmount || this.storage.getEnergyStored() != this.lastEnergy || this.tank.getFluidAmount() != this.lastTank || this.brewTime != this.lastBrewTime) && this.sendUpdateWithInterval()) {
                this.lastCoffeeAmount = this.coffeeCacheAmount;
                this.lastEnergy = this.storage.getEnergyStored();
                this.lastTank = this.tank.getFluidAmount();
                this.lastBrewTime = this.brewTime;
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.writeSyncableNBT(compound, sync);
        this.storage.writeToNBT(compound);
        this.tank.writeToNBT(compound);
        compound.func_74768_a("Cache", this.coffeeCacheAmount);
        compound.func_74768_a("Time", this.brewTime);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.readSyncableNBT(compound, sync);
        this.storage.readFromNBT(compound);
        this.tank.readFromNBT(compound);
        this.coffeeCacheAmount = compound.func_74762_e("Cache");
        this.brewTime = compound.func_74762_e("Time");
    }

    public void storeCoffee() {
        int toAdd;
        if (this.slots[0] != null && this.slots[0].func_77973_b() == InitItems.itemCoffeeBean && (toAdd = 2) <= 300 - this.coffeeCacheAmount) {
            --this.slots[0].field_77994_a;
            if (this.slots[0].field_77994_a <= 0) {
                this.slots[0] = null;
            }
            this.coffeeCacheAmount += toAdd;
        }
        WorldUtil.emptyBucket(this.tank, this.slots, 11, 12, FluidRegistry.WATER);
    }

    public void brew() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.slots[1] != null && this.slots[1].func_77973_b() == InitItems.itemMisc && this.slots[1].func_77960_j() == TheMiscItems.CUP.ordinal() && this.slots[2] == null && this.coffeeCacheAmount >= 15 && this.tank.getFluid() != null && this.tank.getFluid().getFluid() == FluidRegistry.WATER && this.tank.getFluidAmount() >= 500) {
                if (this.storage.getEnergyStored() >= 150) {
                    if (this.brewTime % 30 == 0) {
                        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, ModUtil.MOD_ID_LOWER + ":coffeeMachine", 0.35f, 1.0f);
                    }
                    ++this.brewTime;
                    this.storage.extractEnergy(150, false);
                    if (this.brewTime >= 500) {
                        this.brewTime = 0;
                        ItemStack output = new ItemStack(InitItems.itemCoffee);
                        for (int i = 3; i < this.slots.length - 2; ++i) {
                            CoffeeIngredient ingredient;
                            if (this.slots[i] == null || (ingredient = ItemCoffee.getIngredientFromStack(this.slots[i])) == null || !ingredient.effect(output)) continue;
                            --this.slots[i].field_77994_a;
                            if (this.slots[i].field_77994_a > 0) continue;
                            this.slots[i] = this.slots[i].func_77973_b().getContainerItem(this.slots[i]);
                        }
                        this.slots[2] = output.func_77946_l();
                        --this.slots[1].field_77994_a;
                        if (this.slots[1].field_77994_a <= 0) {
                            this.slots[1] = null;
                        }
                        this.coffeeCacheAmount -= 15;
                        this.tank.drain(500, true);
                    }
                }
            } else {
                this.brewTime = 0;
            }
        }
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return i >= 3 && ItemCoffee.getIngredientFromStack(stack) != null || i == 0 && stack.func_77973_b() == InitItems.itemCoffeeBean || i == 1 && stack.func_77973_b() == InitItems.itemMisc && stack.func_77960_j() == TheMiscItems.CUP.ordinal() || i == 11 && FluidContainerRegistry.containsFluid((ItemStack)stack, (FluidStack)new FluidStack(FluidRegistry.WATER, 1));
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 2 || slot >= 3 && slot < this.slots.length - 2 && ItemCoffee.getIngredientFromStack(stack) == null || slot == 12;
    }

    @Override
    public void onButtonPressed(int buttonID, EntityPlayer player) {
        if (buttonID == 0 && this.brewTime <= 0) {
            this.brew();
        }
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return resource.getFluid() == FluidRegistry.WATER && from != ForgeDirection.DOWN ? this.tank.fill(resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.storage.setEnergyStored(energy);
    }

    @Override
    public FluidStack[] getFluids() {
        return new FluidStack[]{this.tank.getFluid()};
    }

    @Override
    public void setFluids(FluidStack[] fluids) {
        this.tank.setFluid(fluids[0]);
    }
}

