/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.api.Position;
import de.ellpeck.actuallyadditions.mod.tile.IEnergySaver;
import de.ellpeck.actuallyadditions.mod.tile.IRedstoneToggle;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityDirectionalBreaker
extends TileEntityInventoryBase
implements IEnergyReceiver,
IEnergySaver,
IRedstoneToggle {
    public static final int RANGE = 8;
    public static final int ENERGY_USE = 5;
    public EnergyStorage storage = new EnergyStorage(10000);
    private int lastEnergy;
    private int currentTime;
    private boolean activateOnceWithSignal;

    public TileEntityDirectionalBreaker() {
        super(9, "directionalBreaker");
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isRedstonePowered && !this.activateOnceWithSignal && this.storage.getEnergyStored() >= 40) {
                if (this.currentTime > 0) {
                    --this.currentTime;
                    if (this.currentTime <= 0) {
                        this.doWork();
                    }
                } else {
                    this.currentTime = 15;
                }
            }
            if (this.storage.getEnergyStored() != this.lastEnergy && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
            }
        }
    }

    private void doWork() {
        ForgeDirection sideToManipulate = ForgeDirection.getOrientation((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        for (int i = 0; i < 8; ++i) {
            Block blockToBreak;
            Position coordsBlock = WorldUtil.getCoordsFromSide(sideToManipulate, this.field_145851_c, this.field_145848_d, this.field_145849_e, i);
            if (coordsBlock == null || (blockToBreak = this.field_145850_b.func_147439_a(coordsBlock.getX(), coordsBlock.getY(), coordsBlock.getZ())) == null || blockToBreak instanceof BlockAir || !(blockToBreak.func_149712_f(this.field_145850_b, coordsBlock.getX(), coordsBlock.getY(), coordsBlock.getZ()) > -1.0f)) continue;
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            int meta = this.field_145850_b.func_72805_g(coordsBlock.getX(), coordsBlock.getY(), coordsBlock.getZ());
            drops.addAll(blockToBreak.getDrops(this.field_145850_b, coordsBlock.getX(), coordsBlock.getY(), coordsBlock.getZ(), meta, 0));
            if (!WorldUtil.addToInventory((IInventory)this, drops, false)) continue;
            this.field_145850_b.func_72926_e(2001, coordsBlock.getX(), coordsBlock.getY(), coordsBlock.getZ(), Block.func_149682_b((Block)blockToBreak) + (meta << 12));
            WorldUtil.breakBlockAtSide(sideToManipulate, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, i);
            WorldUtil.addToInventory((IInventory)this, drops, true);
            this.storage.extractEnergy(5, false);
            this.func_70296_d();
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.writeSyncableNBT(compound, sync);
        this.storage.writeToNBT(compound);
        compound.func_74768_a("CurrentTime", this.currentTime);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.readSyncableNBT(compound, sync);
        this.storage.readFromNBT(compound);
        this.currentTime = compound.func_74762_e("CurrentTime");
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.storage.setEnergyStored(energy);
    }

    @Override
    public void toggle(boolean to) {
        this.activateOnceWithSignal = to;
    }

    @Override
    public boolean isPulseMode() {
        return this.activateOnceWithSignal;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }
}

