/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.api.Position;
import de.ellpeck.actuallyadditions.mod.tile.IFluidSaver;
import de.ellpeck.actuallyadditions.mod.tile.IRedstoneToggle;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityFluidCollector
extends TileEntityInventoryBase
implements IFluidHandler,
IFluidSaver,
IRedstoneToggle {
    public FluidTank tank = new FluidTank(8000);
    public boolean isPlacer;
    private int lastTankAmount;
    private int currentTime;
    private boolean activateOnceWithSignal;

    public TileEntityFluidCollector(int slots, String name) {
        super(slots, name);
    }

    public TileEntityFluidCollector() {
        super(2, "fluidCollector");
        this.isPlacer = false;
    }

    @Override
    public void toggle(boolean to) {
        this.activateOnceWithSignal = to;
    }

    @Override
    public boolean isPulseMode() {
        return this.activateOnceWithSignal;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }

    private void doWork() {
        ForgeDirection sideToManipulate = ForgeDirection.getOrientation((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        Position coordsBlock = WorldUtil.getCoordsFromSide(sideToManipulate, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0);
        if (coordsBlock != null) {
            Block block;
            Block blockToBreak = this.field_145850_b.func_147439_a(coordsBlock.getX(), coordsBlock.getY(), coordsBlock.getZ());
            if (!this.isPlacer && blockToBreak != null && this.field_145850_b.func_72805_g(coordsBlock.getX(), coordsBlock.getY(), coordsBlock.getZ()) == 0 && 1000 <= this.tank.getCapacity() - this.tank.getFluidAmount()) {
                if (blockToBreak instanceof IFluidBlock && ((IFluidBlock)blockToBreak).getFluid() != null) {
                    if (this.tank.fill(new FluidStack(((IFluidBlock)blockToBreak).getFluid(), 1000), false) >= 1000) {
                        this.tank.fill(new FluidStack(((IFluidBlock)blockToBreak).getFluid(), 1000), true);
                        WorldUtil.breakBlockAtSide(sideToManipulate, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                } else if (blockToBreak == Blocks.field_150353_l || blockToBreak == Blocks.field_150356_k) {
                    if (this.tank.fill(new FluidStack(FluidRegistry.LAVA, 1000), false) >= 1000) {
                        this.tank.fill(new FluidStack(FluidRegistry.LAVA, 1000), true);
                        WorldUtil.breakBlockAtSide(sideToManipulate, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                } else if ((blockToBreak == Blocks.field_150355_j || blockToBreak == Blocks.field_150358_i) && this.tank.fill(new FluidStack(FluidRegistry.WATER, 1000), false) >= 1000) {
                    this.tank.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
                    WorldUtil.breakBlockAtSide(sideToManipulate, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            } else if (this.isPlacer && this.field_145850_b.func_147439_a(coordsBlock.getX(), coordsBlock.getY(), coordsBlock.getZ()).isReplaceable((IBlockAccess)this.field_145850_b, coordsBlock.getX(), coordsBlock.getY(), coordsBlock.getZ()) && this.tank.getFluidAmount() >= 1000 && this.tank.getFluid().getFluid().getBlock() != null && !((block = this.field_145850_b.func_147439_a(this.field_145851_c + sideToManipulate.offsetX, this.field_145848_d + sideToManipulate.offsetY, this.field_145849_e + sideToManipulate.offsetZ)) instanceof IFluidBlock) && block != Blocks.field_150353_l && block != Blocks.field_150355_j && block != Blocks.field_150356_k && block != Blocks.field_150358_i) {
                WorldUtil.placeBlockAtSide(sideToManipulate, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, new ItemStack(this.tank.getFluid().getFluid().getBlock()));
                this.tank.drain(1000, true);
            }
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.isPlacer) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.isPlacer) {
            return this.tank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.isPlacer) {
            return this.tank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.isPlacer;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return !this.isPlacer;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isRedstonePowered && !this.activateOnceWithSignal) {
                if (this.currentTime > 0) {
                    --this.currentTime;
                    if (this.currentTime <= 0) {
                        this.doWork();
                    }
                } else {
                    this.currentTime = 15;
                }
            }
            if (!this.isPlacer) {
                WorldUtil.fillBucket(this.tank, this.slots, 0, 1);
            } else {
                WorldUtil.emptyBucket(this.tank, this.slots, 0, 1);
            }
            if (!this.isPlacer && this.tank.getFluidAmount() > 0) {
                WorldUtil.pushFluid(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.DOWN, this.tank);
                if (!this.isRedstonePowered) {
                    WorldUtil.pushFluid(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.NORTH, this.tank);
                    WorldUtil.pushFluid(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.EAST, this.tank);
                    WorldUtil.pushFluid(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.SOUTH, this.tank);
                    WorldUtil.pushFluid(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.WEST, this.tank);
                }
            }
            if (this.lastTankAmount != this.tank.getFluidAmount() && this.sendUpdateWithInterval()) {
                this.lastTankAmount = this.tank.getFluidAmount();
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.writeSyncableNBT(compound, sync);
        compound.func_74768_a("CurrentTime", this.currentTime);
        this.tank.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.readSyncableNBT(compound, sync);
        this.currentTime = compound.func_74762_e("CurrentTime");
        this.tank.readFromNBT(compound);
    }

    @SideOnly(value=Side.CLIENT)
    public int getTankScaled(int i) {
        return this.tank.getFluidAmount() * i / this.tank.getCapacity();
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (i == 0) {
            if (this.isPlacer) {
                return FluidContainerRegistry.isFilledContainer((ItemStack)stack);
            }
            return stack.func_77969_a(FluidContainerRegistry.EMPTY_BUCKET);
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    @Override
    public FluidStack[] getFluids() {
        return new FluidStack[]{this.tank.getFluid()};
    }

    @Override
    public void setFluids(FluidStack[] fluids) {
        this.tank.setFluid(fluids[0]);
    }

    public static class TileEntityFluidPlacer
    extends TileEntityFluidCollector {
        public TileEntityFluidPlacer() {
            super(2, "fluidPlacer");
            this.isPlacer = true;
        }
    }
}

