/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.mod.tile.IEnergySaver;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFurnaceDouble
extends TileEntityInventoryBase
implements IEnergyReceiver,
IEnergySaver {
    public static final int SLOT_INPUT_1 = 0;
    public static final int SLOT_OUTPUT_1 = 1;
    public static final int SLOT_INPUT_2 = 2;
    public static final int SLOT_OUTPUT_2 = 3;
    public static final int ENERGY_USE = 25;
    private static final int SMELT_TIME = 80;
    public EnergyStorage storage = new EnergyStorage(30000);
    public int firstSmeltTime;
    public int secondSmeltTime;
    private int lastEnergy;
    private int lastFirstSmelt;
    private int lastSecondSmelt;

    public TileEntityFurnaceDouble() {
        super(4, "furnaceDouble");
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            boolean flag = this.firstSmeltTime > 0 || this.secondSmeltTime > 0;
            boolean canSmeltOnFirst = this.canSmeltOn(0, 1);
            boolean canSmeltOnSecond = this.canSmeltOn(2, 3);
            if (canSmeltOnFirst) {
                if (this.storage.getEnergyStored() >= 25) {
                    ++this.firstSmeltTime;
                    if (this.firstSmeltTime >= 80) {
                        this.finishBurning(0, 1);
                        this.firstSmeltTime = 0;
                    }
                }
            } else {
                this.firstSmeltTime = 0;
            }
            if (canSmeltOnSecond) {
                if (this.storage.getEnergyStored() >= 25) {
                    ++this.secondSmeltTime;
                    if (this.secondSmeltTime >= 80) {
                        this.finishBurning(2, 3);
                        this.secondSmeltTime = 0;
                    }
                }
            } else {
                this.secondSmeltTime = 0;
            }
            if (this.storage.getEnergyStored() >= 25 && (this.firstSmeltTime > 0 || this.secondSmeltTime > 0)) {
                this.storage.extractEnergy(25, false);
            }
            if (flag != (this.firstSmeltTime > 0 || this.secondSmeltTime > 0)) {
                this.func_70296_d();
                int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (meta > 3) {
                    if (!this.canSmeltOn(0, 1) && !this.canSmeltOn(2, 3)) {
                        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta - 4, 2);
                    }
                } else {
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta + 4, 2);
                }
            }
            if ((this.lastEnergy != this.storage.getEnergyStored() || this.lastFirstSmelt != this.firstSmeltTime || this.lastSecondSmelt != this.secondSmeltTime) && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
                this.lastFirstSmelt = this.firstSmeltTime;
                this.lastSecondSmelt = this.secondSmeltTime;
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.writeSyncableNBT(compound, sync);
        compound.func_74768_a("FirstSmeltTime", this.firstSmeltTime);
        compound.func_74768_a("SecondSmeltTime", this.secondSmeltTime);
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.readSyncableNBT(compound, sync);
        this.firstSmeltTime = compound.func_74762_e("FirstSmeltTime");
        this.secondSmeltTime = compound.func_74762_e("SecondSmeltTime");
        this.storage.readFromNBT(compound);
    }

    public boolean canSmeltOn(int theInput, int theOutput) {
        if (this.slots[theInput] != null) {
            ItemStack output = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[theInput]);
            if (this.slots[theInput] != null && output != null && (this.slots[theOutput] == null || this.slots[theOutput].func_77969_a(output) && this.slots[theOutput].field_77994_a <= this.slots[theOutput].func_77976_d() - output.field_77994_a)) {
                return true;
            }
        }
        return false;
    }

    public void finishBurning(int theInput, int theOutput) {
        ItemStack output = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[theInput]);
        if (this.slots[theOutput] == null) {
            this.slots[theOutput] = output.func_77946_l();
        } else if (this.slots[theOutput].func_77973_b() == output.func_77973_b()) {
            this.slots[theOutput].field_77994_a += output.field_77994_a;
        }
        --this.slots[theInput].field_77994_a;
        if (this.slots[theInput].field_77994_a <= 0) {
            this.slots[theInput] = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @SideOnly(value=Side.CLIENT)
    public int getFirstTimeToScale(int i) {
        return this.firstSmeltTime * i / 80;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSecondTimeToScale(int i) {
        return this.secondSmeltTime * i / 80;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return (i == 0 || i == 2) && FurnaceRecipes.func_77602_a().func_151395_a(stack) != null;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1 || slot == 3;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.storage.setEnergyStored(energy);
    }
}

