/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class TileEntityInventoryBase
extends TileEntityBase
implements ISidedInventory {
    public ItemStack[] slots;
    public String name;

    public TileEntityInventoryBase(int slots, String name) {
        this.initializeSlots(slots);
        this.name = "container." + ModUtil.MOD_ID_LOWER + "." + name;
    }

    public void initializeSlots(int itemAmount) {
        this.slots = new ItemStack[itemAmount];
    }

    public int[] func_94128_d(int side) {
        if (this.slots.length > 0) {
            int[] theInt = new int[this.slots.length];
            for (int i = 0; i < theInt.length; ++i) {
                theInt[i] = i;
            }
            return theInt;
        }
        return new int[0];
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean isForSync) {
        super.writeSyncableNBT(compound, isForSync);
        if ((!isForSync || this.shouldSyncSlots()) && this.slots.length > 0) {
            NBTTagList tagList = new NBTTagList();
            for (int currentIndex = 0; currentIndex < this.slots.length; ++currentIndex) {
                NBTTagCompound tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)currentIndex);
                if (this.slots[currentIndex] != null) {
                    this.slots[currentIndex].func_77955_b(tagCompound);
                }
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            compound.func_74782_a("Items", (NBTBase)tagList);
        }
    }

    public boolean shouldSyncSlots() {
        return false;
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean isForSync) {
        super.readSyncableNBT(compound, isForSync);
        if ((!isForSync || this.shouldSyncSlots()) && this.slots.length > 0) {
            NBTTagList tagList = compound.func_150295_c("Items", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagCompound = tagList.func_150305_b(i);
                byte slotIndex = tagCompound.func_74771_c("Slot");
                if (slotIndex < 0 || slotIndex >= this.slots.length) continue;
                this.slots[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
            }
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public ItemStack func_70304_b(int i) {
        return this.func_70301_a(i);
    }

    public void func_70299_a(int i, ItemStack stack) {
        this.slots[i] = stack;
        this.func_70296_d();
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        if (i < this.func_70302_i_()) {
            return this.slots[i];
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack stackAt = this.slots[i];
                this.slots[i] = null;
                this.func_70296_d();
                return stackAt;
            }
            ItemStack stackAt = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            this.func_70296_d();
            return stackAt;
        }
        return null;
    }

    public String func_145825_b() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

