/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityXPSolidifier
extends TileEntityInventoryBase
implements IButtonReactor {
    public short amount;
    private short lastAmount;
    private int[] buttonAmounts = new int[]{1, 5, 10, 20, 30, 40, 50, 64, -999};

    public TileEntityXPSolidifier() {
        super(1, "xpSolidifier");
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.amount > 0) {
                if (this.slots[0] == null) {
                    int toSet = this.amount > 64 ? 64 : (int)this.amount;
                    this.slots[0] = new ItemStack(InitItems.itemSolidifiedExperience, toSet);
                    this.amount = (short)(this.amount - toSet);
                } else if (this.slots[0].field_77994_a < 64) {
                    int needed = 64 - this.slots[0].field_77994_a;
                    int toAdd = this.amount > needed ? needed : (int)this.amount;
                    this.slots[0].field_77994_a += toAdd;
                    this.amount = (short)(this.amount - toAdd);
                }
            }
            if (this.lastAmount != this.amount && this.sendUpdateWithInterval()) {
                this.lastAmount = this.amount;
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.writeSyncableNBT(compound, sync);
        compound.func_74777_a("Amount", this.amount);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.readSyncableNBT(compound, sync);
        this.amount = compound.func_74765_d("Amount");
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return true;
    }

    @Override
    public void onButtonPressed(int buttonID, EntityPlayer player) {
        if (buttonID < this.buttonAmounts.length && this.getPlayerXP(player) > 0) {
            int xp;
            int n = xp = this.buttonAmounts[buttonID] == -999 ? this.getPlayerXP(player) / 8 : this.buttonAmounts[buttonID];
            if (this.amount < Short.MAX_VALUE - xp && this.getPlayerXP(player) >= 8 * xp) {
                this.addPlayerXP(player, -(8 * xp));
                if (!this.field_145850_b.field_72995_K) {
                    this.amount = (short)(this.amount + xp);
                }
            }
        }
    }

    private int getPlayerXP(EntityPlayer player) {
        return (int)((float)this.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    private void addPlayerXP(EntityPlayer player, int amount) {
        int experience;
        player.field_71067_cb = experience = this.getPlayerXP(player) + amount;
        int level = 0;
        while (this.getExperienceForLevel(level) <= experience) {
            ++level;
        }
        player.field_71068_ca = level - 1;
        int expForLevel = this.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    private int getExperienceForLevel(int level) {
        if (level > 0) {
            if (level > 0 && level < 16) {
                return level * 17;
            }
            if (level > 15 && level < 31) {
                return (int)(1.5 * Math.pow(level, 2.0) - 29.5 * (double)level + 360.0);
            }
            return (int)(3.5 * Math.pow(level, 2.0) - 151.5 * (double)level + 2220.0);
        }
        return 0;
    }
}

