/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.archimedes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import darkevilmac.archimedes.common.ArchimedesConfig;
import darkevilmac.archimedes.common.CommonProxy;
import darkevilmac.archimedes.common.command.CommandASHelp;
import darkevilmac.archimedes.common.command.CommandDisassembleNear;
import darkevilmac.archimedes.common.command.CommandDisassembleShip;
import darkevilmac.archimedes.common.command.CommandShipInfo;
import darkevilmac.archimedes.common.entity.EntityParachute;
import darkevilmac.archimedes.common.entity.EntitySeat;
import darkevilmac.archimedes.common.entity.EntityShip;
import darkevilmac.archimedes.common.handler.ConnectionHandler;
import darkevilmac.archimedes.common.network.ArchimedesShipsMessageToMessageCodec;
import darkevilmac.archimedes.common.network.ArchimedesShipsPacketHandler;
import darkevilmac.archimedes.common.network.NetworkUtil;
import darkevilmac.archimedes.common.object.ArchimedesObjects;
import darkevilmac.movingworld.MovingWorld;
import io.netty.channel.ChannelHandler;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="ArchimedesShipsPlus", name="Archimedes' Ships Plus", version="1.7.10-1.8.1", dependencies="required-after:MovingWorld@", guiFactory="darkevilmac.archimedes.client.gui.ArchimedesGUIFactory")
public class ArchimedesShipMod {
    public static final String MOD_ID = "ArchimedesShipsPlus";
    public static final String MOD_VERSION = "1.7.10-1.8.1";
    public static final String MOD_NAME = "Archimedes' Ships Plus";
    public static final String MOD_GUIFACTORY = "darkevilmac.archimedes.client.gui.ArchimedesGUIFactory";
    public static CreativeTabs creativeTab = new CreativeTabs("archimedesTab"){

        public Item func_78016_d() {
            return Item.func_150898_a((Block)ArchimedesObjects.blockEngine);
        }
    };
    @Mod.Instance(value="ArchimedesShipsPlus")
    public static ArchimedesShipMod instance;
    @SidedProxy(clientSide="darkevilmac.archimedes.client.ClientProxy", serverSide="darkevilmac.archimedes.common.CommonProxy")
    public static CommonProxy proxy;
    public static ArchimedesObjects objects;
    public static Logger modLog;
    public ArchimedesConfig modConfig;
    public NetworkUtil network = new NetworkUtil();

    @Mod.EventHandler
    public void preInitMod(FMLPreInitializationEvent event) {
        modLog = event.getModLog();
        objects = new ArchimedesObjects();
        MinecraftForge.EVENT_BUS.register((Object)this);
        objects.preInit(event);
        this.modConfig = new ArchimedesConfig(new Configuration(event.getSuggestedConfigurationFile()));
        this.modConfig.loadAndSave();
        this.modConfig.postLoad();
    }

    @Mod.EventHandler
    public void initMod(FMLInitializationEvent event) {
        try {
            MovingWorld.instance.metaRotations.registerMetaRotationFile("archimedesships.mrot", this.getClass().getResourceAsStream("/mrot/archimedesships.mrot"));
        }
        catch (IOException e) {
            modLog.error("UNABLE TO LOAD ARCHIMEDESSHIPS.MROT");
        }
        this.network.channels = NetworkRegistry.INSTANCE.newChannel(MOD_ID, new ChannelHandler[]{new ArchimedesShipsMessageToMessageCodec(), new ArchimedesShipsPacketHandler()});
        objects.init(event);
        MinecraftForge.EVENT_BUS.register((Object)new ConnectionHandler());
        FMLCommonHandler.instance().bus().register((Object)new ConnectionHandler());
        EntityRegistry.registerModEntity(EntityShip.class, (String)"shipmod", (int)1, (Object)this, (int)64, (int)this.modConfig.shipEntitySyncRate, (boolean)true);
        EntityRegistry.registerModEntity(EntitySeat.class, (String)"attachment.seat", (int)2, (Object)this, (int)64, (int)100, (boolean)false);
        EntityRegistry.registerModEntity(EntityParachute.class, (String)"parachute", (int)3, (Object)this, (int)32, (int)this.modConfig.shipEntitySyncRate, (boolean)true);
        proxy.registerKeyHandlers(this.modConfig);
        proxy.registerEventHandlers();
        proxy.registerRenderers();
        this.modConfig.addBlacklistWhitelistEntries();
    }

    @Mod.EventHandler
    public void postInitMod(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        this.registerASCommand(event, new CommandASHelp());
        this.registerASCommand(event, new CommandDisassembleShip());
        this.registerASCommand(event, new CommandShipInfo());
        this.registerASCommand(event, new CommandDisassembleNear());
        Collections.sort(CommandASHelp.asCommands);
    }

    private void registerASCommand(FMLServerStartingEvent event, CommandBase commandbase) {
        event.registerServerCommand((ICommand)commandbase);
        CommandASHelp.asCommands.add(commandbase);
    }

    private void registerBlock(String id, Block block) {
        this.registerBlock(id, block, ItemBlock.class);
    }

    private void registerBlock(String id, Block block, Class<? extends ItemBlock> itemblockclass) {
        block.func_149663_c("archimedes." + id);
        block.func_149658_d("archimedes:" + id);
        GameRegistry.registerBlock((Block)block, itemblockclass, (String)id);
    }

    @Mod.EventHandler
    public void missingMappingFound(FMLMissingMappingsEvent event) {
        ImmutableList missingMappingList;
        ListMultimap missing;
        if (event != null && event.getAll() != null && !event.getAll().isEmpty() && (missing = (ListMultimap)ReflectionHelper.getPrivateValue(FMLMissingMappingsEvent.class, (Object)event, (String[])new String[]{"missing"})) != null && (missingMappingList = ImmutableList.copyOf((Collection)missing.get((Object)"ArchimedesShips"))) != null && !missingMappingList.isEmpty()) {
            Logger log = LogManager.getLogger((String)MOD_ID);
            log.info("ARCHIMEDES LEGACY MAPPINGS FOUND");
            for (FMLMissingMappingsEvent.MissingMapping mapping : missingMappingList) {
                if (mapping == null || mapping.type == null || mapping.name == null || mapping.name.isEmpty()) continue;
                String name = mapping.name.substring("ArchimedesShips:".length());
                if (mapping.type == GameRegistry.Type.BLOCK) {
                    mapping.remap(GameRegistry.findBlock((String)MOD_ID, (String)name));
                } else {
                    mapping.remap(Item.func_150898_a((Block)GameRegistry.findBlock((String)MOD_ID, (String)name)));
                }
                log.debug("ArchimedesShips:" + name + " ~~~> " + "ArchimedesShipsPlus:" + name);
            }
            log.info("REMAPPED TO ARCHIMEDES SHIPS PLUS, ENJOY! ~Darkevilmac");
        }
    }
}

