/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.archimedes.common;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import darkevilmac.archimedes.common.object.ArchimedesObjects;
import darkevilmac.movingworld.MovingWorld;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.input.Keyboard;

public class ArchimedesConfig {
    public static final int CONTROL_TYPE_VANILLA = 0;
    public static final int CONTROL_TYPE_ARCHIMEDES = 1;
    public boolean enableAirShips;
    public boolean enableSubmersibles;
    public int shipEntitySyncRate;
    public int maxShipChunkBlocks;
    public float flyBalloonRatio;
    public float submersibleFillRatio;
    public int shipControlType;
    public float turnSpeed;
    public float speedLimit;
    public float bankingMultiplier;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbUp;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbDown;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbBrake;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbAlign;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbDisassemble;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbShipInv;
    public boolean disassembleOnDismount;
    public boolean enginesMandatory;
    public Set<String> balloonAlternatives;
    private Configuration config;
    public ArrayList<Block> seats;

    public ArchimedesConfig(Configuration configuration) {
        this.config = configuration;
        this.balloonAlternatives = new HashSet<String>();
        this.seats = new ArrayList();
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void loadAndSave() {
        String[] seatNames;
        this.config.load();
        this.shipEntitySyncRate = this.config.get("settings", "sync_rate", 20, "The amount of ticks between a server-client synchronization. Higher numbers reduce network traffic. Lower numbers increase multiplayer experience. 20 ticks = 1 second").getInt();
        this.enableAirShips = this.config.get("settings", "enable_air_ships", true, "Enable or disable air ships.").getBoolean(true);
        this.enableSubmersibles = this.config.get("settings", "enable_submersibles", true, "Enable or disable the ability to submerse ships.").getBoolean(true);
        this.bankingMultiplier = (float)this.config.get("settings", "banking_multiplier", 3.0, "A multiplier for how much ships bank while making turns. Set a positive value for passive banking or a negative value for active banking. 0 disables banking.").getDouble(3.0);
        this.enginesMandatory = this.config.get("settings", "mandatory_engines", false, "Are engines required for a ship to move?").getBoolean();
        this.shipControlType = this.config.get("control", "control_type", 1, "Set to 0 to use vanilla boat controls, set to 1 to use the new Archimedes controls.").getInt();
        this.turnSpeed = (float)this.config.get("control", "turn_speed", 1.0, "A multiplier of the ship's turn speed.").getDouble(1.0);
        this.speedLimit = (float)this.config.get("control", "speed_limit", 30.0, "The maximum velocity a ship can have, in objects per second. This does not affect acceleration.").getDouble(30.0);
        this.speedLimit /= 20.0f;
        this.disassembleOnDismount = this.config.get("control", "decompile_on_dismount", false).getBoolean(false);
        this.maxShipChunkBlocks = this.config.get("mobile_chunk", "max_chunk_blocks", 2048, "The maximum amount of objects that a mobile ship chunk may contain.").getInt();
        this.flyBalloonRatio = (float)this.config.get("mobile_chunk", "airship_balloon_ratio", 0.4, "The part of the total amount of objects that should be balloon objects in order to make an airship.").getDouble(0.4);
        this.submersibleFillRatio = (float)this.config.get("mobile_chunk", "submersible_fill_ratio", 0.3, "The part of the ship that needs to not be water fillable for it to be considered submersible.").getDouble(0.9);
        for (String seat : seatNames = this.config.get("settings", "seat", new String[]{"archimedesshipsplus:seat", "end_portal_frame"}, "Blocks that are considered seats, (BlockSeat is hardcoded so this is just an example.)").getStringList()) {
            this.seats.add(Block.func_149684_b((String)seat));
        }
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.loadKeybindings();
        }
        this.config.save();
    }

    public void addBlacklistWhitelistEntries() {
        MovingWorld.instance.mConfig.addBlacklistedBlock(ArchimedesObjects.blockBuffer);
        MovingWorld.instance.mConfig.addWhitelistedBlock((Block)ArchimedesObjects.blockMarkShip);
        MovingWorld.instance.mConfig.addWhitelistedBlock(ArchimedesObjects.blockFloater);
        MovingWorld.instance.mConfig.addWhitelistedBlock(ArchimedesObjects.blockBalloon);
        MovingWorld.instance.mConfig.addWhitelistedBlock((Block)ArchimedesObjects.blockGauge);
        MovingWorld.instance.mConfig.addWhitelistedBlock((Block)ArchimedesObjects.blockSeat);
        MovingWorld.instance.mConfig.addWhitelistedBlock(ArchimedesObjects.blockEngine);
        MovingWorld.instance.mConfig.addWhitelistedBlock(ArchimedesObjects.blockAnchorPoint);
    }

    public void postLoad() {
        Block[] defaultBalloonBlocks = new Block[]{ArchimedesObjects.blockBalloon};
        String[] balloonBlockNames = new String[defaultBalloonBlocks.length];
        for (int i = 0; i < defaultBalloonBlocks.length; ++i) {
            balloonBlockNames[i] = Block.field_149771_c.func_148750_c((Object)defaultBalloonBlocks[i]).toString();
        }
        this.config.load();
        String[] balloonBlocks = this.config.get("mobile_chunk", "balloon_blocks", balloonBlockNames, "A list of blocks that are taken into account for ship flight capability").getStringList();
        Collections.addAll(this.balloonAlternatives, balloonBlocks);
        this.config.save();
    }

    @SideOnly(value=Side.CLIENT)
    private void loadKeybindings() {
        this.kbUp = new KeyBinding("key.archimedes.up", this.getKeyIndex(this.config, "key_ascent", 45), "Archimedes");
        this.kbDown = new KeyBinding("key.archimedes.down", this.getKeyIndex(this.config, "key_descent", 44), "Archimedes");
        this.kbBrake = new KeyBinding("key.archimedes.brake", this.getKeyIndex(this.config, "key_brake", 46), "Archimedes");
        this.kbAlign = new KeyBinding("key.archimedes.align", this.getKeyIndex(this.config, "key_align", 13), "Archimedes");
        this.kbDisassemble = new KeyBinding("key.archimedes.decompile", this.getKeyIndex(this.config, "key_decompile", 43), "Archimedes");
        this.kbShipInv = new KeyBinding("key.archimedes.shipinv", this.getKeyIndex(this.config, "key_shipinv", 37), "Archimedes");
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71474_y.field_74324_K = (KeyBinding[])ArrayUtils.addAll((Object[])mc.field_71474_y.field_74324_K, (Object[])new KeyBinding[]{this.kbUp, this.kbDown, this.kbBrake, this.kbAlign, this.kbDisassemble, this.kbShipInv});
    }

    @SideOnly(value=Side.CLIENT)
    private int getKeyIndex(Configuration config, String name, int defaultkey) {
        return Keyboard.getKeyIndex((String)config.get("control", name, Keyboard.getKeyName((int)defaultkey)).getString());
    }

    public boolean isBalloon(Block block) {
        return this.balloonAlternatives.contains(Block.field_149771_c.func_148750_c((Object)block).toString());
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("ArchimedesShipsPlus")) {
            if (this.config.hasChanged()) {
                this.config.save();
            }
            this.loadAndSave();
        }
    }

    public Configuration getConfig() {
        return this.config;
    }
}

