/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.archimedes.common.entity;

import darkevilmac.archimedes.common.object.ArchimedesObjects;
import darkevilmac.archimedes.common.tileentity.TileEntityHelm;
import darkevilmac.movingworld.common.chunk.LocatedBlock;
import darkevilmac.movingworld.common.chunk.assembly.CanAssemble;
import darkevilmac.movingworld.common.chunk.assembly.MovingWorldAssemblyInteractor;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ShipAssemblyInteractor
extends MovingWorldAssemblyInteractor {
    private int balloonCount;

    public void toByteBuf(ByteBuf byteBuf) {
        byteBuf.writeInt(this.getBalloonCount());
    }

    public MovingWorldAssemblyInteractor fromByteBuf(byte resultCode, ByteBuf buf) {
        if (resultCode == 0) {
            return new ShipAssemblyInteractor();
        }
        int balloons = buf.readInt();
        ShipAssemblyInteractor assemblyInteractor = new ShipAssemblyInteractor();
        assemblyInteractor.setBalloonCount(balloons);
        return assemblyInteractor;
    }

    public MovingWorldAssemblyInteractor fromNBT(NBTTagCompound tag, World world) {
        ShipAssemblyInteractor mov = new ShipAssemblyInteractor();
        mov.setBalloonCount(tag.func_74762_e("balloonCount"));
        return mov;
    }

    public void blockAssembled(LocatedBlock locatedBlock) {
        if (locatedBlock.block == ArchimedesObjects.blockBalloon) {
            ++this.balloonCount;
        }
    }

    public boolean isBlockMovingWorldMarker(Block block) {
        if (block != null) {
            return block.func_149739_a() == ArchimedesObjects.blockMarkShip.func_149739_a();
        }
        return false;
    }

    public boolean isTileMovingWorldMarker(TileEntity tile) {
        if (tile != null) {
            return tile instanceof TileEntityHelm;
        }
        return false;
    }

    public CanAssemble isBlockAllowed(World world, Block block, int x, int y, int z) {
        CanAssemble canAssemble = super.isBlockAllowed(world, block, x, y, z);
        if (block == ArchimedesObjects.blockStickyBuffer) {
            canAssemble.assembleThenCancel = true;
        }
        return canAssemble;
    }

    public int getBalloonCount() {
        return this.balloonCount;
    }

    public void setBalloonCount(int balloonCount) {
        this.balloonCount = balloonCount;
    }

    public void writeNBTFully(NBTTagCompound compound) {
        this.writeNBTMetadata(compound);
    }

    public void writeNBTMetadata(NBTTagCompound compound) {
        compound.func_74768_a("balloonCount", this.getBalloonCount());
    }
}

