/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.archimedes.common.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import darkevilmac.archimedes.common.network.ArchimedesShipsMessage;
import darkevilmac.archimedes.common.network.AssembleResultMessage;
import darkevilmac.archimedes.common.network.ClientChangeSubmerseMessage;
import darkevilmac.archimedes.common.network.ClientHelmActionMessage;
import darkevilmac.archimedes.common.network.ClientOpenGuiMessage;
import darkevilmac.archimedes.common.network.ClientRenameShipMessage;
import darkevilmac.archimedes.common.network.ControlInputMessage;
import darkevilmac.archimedes.common.network.TranslatedChatMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;

public class ArchimedesShipsMessageToMessageCodec
extends FMLIndexedMessageToMessageCodec<ArchimedesShipsMessage> {
    private int index = 1;

    public ArchimedesShipsMessageToMessageCodec() {
        this.addDiscriminator(AssembleResultMessage.class);
        this.addDiscriminator(ClientHelmActionMessage.class);
        this.addDiscriminator(ClientOpenGuiMessage.class);
        this.addDiscriminator(ClientRenameShipMessage.class);
        this.addDiscriminator(ControlInputMessage.class);
        this.addDiscriminator(TranslatedChatMessage.class);
        this.addDiscriminator(ClientChangeSubmerseMessage.class);
    }

    public FMLIndexedMessageToMessageCodec<ArchimedesShipsMessage> addDiscriminator(Class<? extends ArchimedesShipsMessage> type) {
        FMLIndexedMessageToMessageCodec ret = super.addDiscriminator(this.index, type);
        ++this.index;
        return ret;
    }

    public void encodeInto(ChannelHandlerContext ctx, ArchimedesShipsMessage msg, ByteBuf target) throws Exception {
        msg.encodeInto(ctx, target, FMLCommonHandler.instance().getSide());
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, ArchimedesShipsMessage msg) {
        switch (FMLCommonHandler.instance().getEffectiveSide()) {
            case CLIENT: {
                EntityPlayer player = this.getClientPlayer();
                msg.decodeInto(ctx, source, player, FMLCommonHandler.instance().getSide());
                break;
            }
            case SERVER: {
                EntityPlayer player = this.getServerPlayer(ctx);
                msg.decodeInto(ctx, source, player, FMLCommonHandler.instance().getSide());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    private EntityPlayer getServerPlayer(ChannelHandlerContext ctx) {
        INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
        return ((NetHandlerPlayServer)netHandler).field_147369_b;
    }
}

