/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.archimedes.common.network;

import cpw.mods.fml.relauncher.Side;
import darkevilmac.archimedes.client.gui.ContainerHelm;
import darkevilmac.archimedes.common.entity.ShipAssemblyInteractor;
import darkevilmac.archimedes.common.network.ArchimedesShipsMessage;
import darkevilmac.movingworld.common.chunk.assembly.AssembleResult;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;

public class AssembleResultMessage
extends ArchimedesShipsMessage {
    public AssembleResult result;
    public ShipAssemblyInteractor interactor;
    public boolean prevFlag;

    public AssembleResultMessage() {
        this.result = null;
        this.prevFlag = false;
    }

    public AssembleResultMessage(AssembleResult compileResult, boolean prev) {
        this.result = compileResult;
        this.prevFlag = prev;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buf, Side side) {
        buf.writeBoolean(this.prevFlag);
        if (this.result == null) {
            buf.writeByte(0);
        } else {
            buf.writeByte(this.result.getCode());
            buf.writeInt(this.result.getBlockCount());
            buf.writeInt(this.result.getTileEntityCount());
            buf.writeFloat(this.result.getMass());
            this.result.assemblyInteractor.toByteBuf(buf);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buf, EntityPlayer player, Side side) {
        if (side.isClient()) {
            this.prevFlag = buf.readBoolean();
            byte resultCode = buf.readByte();
            this.result = new AssembleResult((int)resultCode, buf);
            this.result.assemblyInteractor = new ShipAssemblyInteractor().fromByteBuf(resultCode, buf);
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerHelm) {
            if (this.prevFlag) {
                ((ContainerHelm)player.field_71070_bA).tileEntity.setPrevAssembleResult(this.result);
                ((ContainerHelm)player.field_71070_bA).tileEntity.getPrevAssembleResult().assemblyInteractor = this.result.assemblyInteractor;
            } else {
                ((ContainerHelm)player.field_71070_bA).tileEntity.setAssembleResult(this.result);
                ((ContainerHelm)player.field_71070_bA).tileEntity.getAssembleResult().assemblyInteractor = this.result.assemblyInteractor;
            }
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

