/*
 * Decompiled with CFR 0.152.
 */
package com.brsanthu.googleanalytics;

import com.brsanthu.googleanalytics.DefaultRequest;
import com.brsanthu.googleanalytics.GaUtils;
import com.brsanthu.googleanalytics.GoogleAnalyticsConfig;
import com.brsanthu.googleanalytics.RequestParameterDiscoverer;

public class DefaultRequestParameterDiscoverer
implements RequestParameterDiscoverer {
    @Override
    public DefaultRequest discoverParameters(GoogleAnalyticsConfig config, DefaultRequest request) {
        try {
            if (GaUtils.isEmpty(config.getUserAgent())) {
                config.setUserAgent(this.getUserAgentString());
            }
            if (GaUtils.isEmpty(request.userLanguage())) {
                String region = System.getProperty("user.region");
                if (GaUtils.isEmpty(region)) {
                    region = System.getProperty("user.country");
                }
                request.userLanguage(System.getProperty("user.language") + "-" + region);
            }
            if (GaUtils.isEmpty(request.documentEncoding())) {
                request.documentEncoding(System.getProperty("file.encoding"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return request;
    }

    protected String getUserAgentString() {
        StringBuilder sb = new StringBuilder("java");
        GaUtils.appendSystemProperty(sb, "java.runtime.version");
        GaUtils.appendSystemProperty(sb, "java.specification.vendor");
        GaUtils.appendSystemProperty(sb, "java.vm.name");
        GaUtils.appendSystemProperty(sb, "os.name");
        GaUtils.appendSystemProperty(sb, "os.version");
        GaUtils.appendSystemProperty(sb, "os.arch");
        return sb.toString();
    }
}

