/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import matteroverdrive.blocks.includes.MOBlockMachine;
import matteroverdrive.client.render.block.MOBlockRenderer;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.init.MatterOverdriveBlocks;
import matteroverdrive.init.MatterOverdriveIcons;
import matteroverdrive.machines.fusionReactorController.TileEntityMachineFusionReactorController;
import matteroverdrive.util.MOBlockHelper;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockFusionReactorController
extends MOBlockMachine {
    public BlockFusionReactorController(Material material, String name) {
        super(material, name);
        this.func_149711_c(30.0f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.setHasGui(true);
        this.field_149784_t = 10;
        this.setRotationType(2);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == meta) {
            return MatterOverdriveIcons.Monitor_back;
        }
        if (side == MOBlockHelper.getRightSide(meta) || side == MOBlockHelper.getLeftSide(meta)) {
            return MatterOverdriveBlocks.decomposer.iconTop;
        }
        return MatterOverdriveIcons.YellowStripes;
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityMachineFusionReactorController();
    }

    @Override
    public void func_149689_a(World World2, int x, int y, int z, EntityLivingBase player, ItemStack item) {
        int l = BlockPistonBase.func_150071_a((World)World2, (int)x, (int)y, (int)z, (EntityLivingBase)player);
        World2.func_72921_c(x, y, z, l, 2);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityMachineFusionReactorController && ((TileEntityMachineFusionReactorController)tileEntity).isValidStructure()) {
            return super.func_149727_a(world, x, y, z, player, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public int func_149645_b() {
        return MOBlockRenderer.renderID;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        super.onConfigChanged(config);
        TileEntityMachineFusionReactorController.ENERGY_STORAGE = config.getMachineInt(this.func_149739_a(), "storage.energy", 100000000, String.format("How much energy can the %s hold", this.func_149732_F()));
        TileEntityMachineFusionReactorController.MATTER_STORAGE = config.getMachineInt(this.func_149739_a(), "storage.matter", 2048, String.format("How much matter can the %s hold", this.func_149732_F()));
        TileEntityMachineFusionReactorController.ENERGY_PER_TICK = config.getMachineInt(this.func_149739_a(), "output.energy", 2048, "The Energy Output per tick. Dependant on the size of the anomaly as well");
        TileEntityMachineFusionReactorController.MATTER_DRAIN_PER_TICK = (float)config.getMachineDouble(this.func_149739_a(), "drain.matter", 0.0125, "How much matter is drained per tick. Dependant on the size of the anomaly as well");
        TileEntityMachineFusionReactorController.MAX_GRAVITATIONAL_ANOMALY_DISTANCE = config.getMachineInt(this.func_149739_a(), "distance.anomaly", 3, "The maximum distance of the anomaly");
        TileEntityMachineFusionReactorController.STRUCTURE_CHECK_DELAY = config.getMachineInt(this.func_149739_a(), "check.delay", 40, "The time delay between each structure check");
    }
}

