/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import matteroverdrive.blocks.includes.MOMatterEnergyStorageBlock;
import matteroverdrive.client.render.block.RendererBlockReplicator;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.init.MatterOverdriveIcons;
import matteroverdrive.tile.TileEntityMachineReplicator;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockReplicator
extends MOMatterEnergyStorageBlock {
    public float replication_volume;
    public boolean hasVentParticles;

    public BlockReplicator(Material material, String name) {
        super(material, name, true, true);
        this.func_149711_c(20.0f);
        this.func_149752_b(9.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.setHasGui(true);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        return MatterOverdriveIcons.Base;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityMachineReplicator();
    }

    public int func_149645_b() {
        return RendererBlockReplicator.renderID;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        super.onConfigChanged(config);
        this.replication_volume = (float)config.getMachineDouble(this.func_149739_a(), "volume.replicate", 1.0, "The volume of the replication animation");
        this.hasVentParticles = config.getMachineBool(this.func_149739_a(), "particles.vent", true, "Should vent particles be displayed");
        TileEntityMachineReplicator.MATTER_STORAGE = config.getMachineInt(this.func_149739_a(), "storage.matter", 1024, "How much matter can the replicator hold");
        TileEntityMachineReplicator.ENERGY_STORAGE = config.getMachineInt(this.func_149739_a(), "storage.energy", 512000, "How much energy can the replicator hold");
        TileEntityMachineReplicator.REPLICATE_ENERGY_PER_MATTER = config.getMachineInt(this.func_149739_a(), "cost.replication.energy", 16000, "The total replication cost of each matter value. The energy cost is calculated like so: (matterAmount*EnergyCost)");
        TileEntityMachineReplicator.REPLICATE_SPEED_PER_MATTER = config.getMachineInt(this.func_149739_a(), "speed.replication", 120, "The replication speed in ticks per matter value");
    }
}

