/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.blocks.includes;

import cofh.api.block.IDismantleable;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import matteroverdrive.api.IMOTileEntity;
import matteroverdrive.blocks.includes.MOBlockContainer;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.Slot;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.items.includes.MOMachineBlockItem;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOInventoryHelper;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.MachineHelper;
import matteroverdrive.util.MatterHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public abstract class MOBlockMachine
extends MOBlockContainer
implements IDismantleable,
IConfigSubscriber {
    public float volume = 1.0f;
    public boolean hasGui;

    public MOBlockMachine(Material material, String name) {
        super(material, name);
    }

    @Override
    protected void registerBlock() {
        GameRegistry.registerBlock((Block)this, MOMachineBlockItem.class, (String)this.func_149739_a().substring(5));
    }

    public boolean doNormalDrops(World world, int x, int y, int z) {
        return false;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
        IMOTileEntity entity = (IMOTileEntity)world.func_147438_o(x, y, z);
        if (entity != null) {
            try {
                entity.readFromPlaceItem(itemStack);
            }
            catch (Exception e) {
                e.printStackTrace();
                FMLLog.log((Level)Level.ERROR, (String)"Could not load settings from placing item", (Object[])new Object[]{e});
            }
            entity.onPlaced(world, entityLiving);
        }
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        Inventory inventory = this.getInventory(world, x, y, z);
        if (inventory != null) {
            MatterHelper.DropInventory(world, inventory, x, y, z);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        return MachineHelper.canOpenMachine(world, x, y, z, player, this.hasGui, this.getUnlocalizedMessage(0));
    }

    protected String getUnlocalizedMessage(int type) {
        switch (type) {
            case 0: {
                return "alert.no_rights";
            }
        }
        return "alert.no_access_default";
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (MachineHelper.canRemoveMachine(world, player, x, y, z, willHarvest)) {
            return world.func_147468_f(x, y, z);
        }
        return false;
    }

    public ItemStack getNBTDrop(World world, int x, int y, int z, IMOTileEntity te) {
        int meta = this.func_149692_a(world.func_72805_g(x, y, z));
        ItemStack itemStack = new ItemStack((Block)this, 1, meta);
        if (te != null) {
            te.writeToDropItem(itemStack);
        }
        return itemStack;
    }

    public boolean hasGui() {
        return this.hasGui;
    }

    public void setHasGui(boolean hasGui) {
        this.hasGui = hasGui;
    }

    @Override
    public ArrayList<ItemStack> dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnDrops) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack blockItem = this.getNBTDrop(world, x, y, z, (IMOTileEntity)world.func_147438_o(x, y, z));
        Inventory inventory = this.getInventory(world, x, y, z);
        items.add(blockItem);
        if (inventory != null) {
            for (int i1 = 0; i1 < inventory.func_70302_i_(); ++i1) {
                Slot slot = inventory.getSlot(i1);
                ItemStack itemstack = slot.getItem();
                if (itemstack == null || !slot.keepOnDismantle()) continue;
                slot.setItem(null);
            }
        }
        Block block = world.func_147439_a(x, y, z);
        int l = world.func_72805_g(x, y, z);
        boolean flag = block.removedByPlayer(world, player, x, y, z, true);
        super.func_149749_a(world, x, y, z, block, l);
        if (flag) {
            block.func_149664_b(world, x, y, z, l);
        }
        if (!returnDrops) {
            this.func_149642_a(world, x, y, z, blockItem);
        } else {
            MOInventoryHelper.insertItemStackIntoInventory((IInventory)player.field_71071_by, blockItem, 0);
        }
        return items;
    }

    protected Inventory getInventory(World world, int x, int y, int z) {
        if (world.func_147438_o(x, y, z) instanceof MOTileEntityMachine) {
            MOTileEntityMachine machine = (MOTileEntityMachine)world.func_147438_o(x, y, z);
            return machine.getInventoryContainer();
        }
        return null;
    }

    @Override
    public boolean canDismantle(EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof MOTileEntityMachine) {
            if (player.field_71075_bZ.field_75098_d || !((MOTileEntityMachine)tileEntity).hasOwner()) {
                return true;
            }
            if (((MOTileEntityMachine)tileEntity).getOwner().equals(player.func_146103_bH().getId())) {
                return true;
            }
            if (world.field_72995_K) {
                ChatComponentText message = new ChatComponentText(EnumChatFormatting.GOLD + "[Matter Overdrive] " + EnumChatFormatting.RED + MOStringHelper.translateToLocal("alert.no_rights.dismantle").replace("$0", this.func_149732_F()));
                message.func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED));
                player.func_145747_a((IChatComponent)message);
            }
            return false;
        }
        return true;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        config.initMachineCategory(this.func_149739_a());
        this.volume = (float)config.getMachineDouble(this.func_149739_a(), "volume", 1.0, "The volume of the Machine");
    }
}

