/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.data;

public class Color
extends Number {
    public static final Color WHITE = new Color(255, 255, 255);
    public static final Color RED = new Color(255, 0, 0);
    public static final Color GREEN = new Color(0, 255, 0);
    public static final Color BLUE = new Color(0, 0, 255);
    private final int color;

    public Color(int color) {
        this.color = color;
    }

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color(int r, int g, int b, int a) {
        this(b & 0xFF | (g & 0xFF) << 8 | (r & 0xFF) << 16 | (a & 0xFF) << 24);
    }

    public Color multiplyWithoutAlpha(float multiply) {
        return this.multiply(multiply, multiply, multiply, 1.0f);
    }

    public Color multiplyWithAlpha(float multiply) {
        return this.multiply(multiply, multiply, multiply, multiply);
    }

    public Color multiply(float rm, float gm, float bm, float am) {
        return new Color((int)((float)this.getIntR() * rm), (int)((float)this.getIntG() * gm), (int)((float)this.getIntB() * bm), (int)((float)this.getIntA() * am));
    }

    public Color add(Color color) {
        return new Color(this.getIntR() + color.getIntR(), this.getIntG() + color.getIntG(), this.getIntB() + color.getIntB(), this.getIntA() + color.getIntA());
    }

    public Color subtract(Color color) {
        return new Color(this.getIntR() - color.getIntR(), this.getIntG() - color.getIntG(), this.getIntB() - color.getIntB(), this.getIntA() - color.getIntA());
    }

    public int getIntR() {
        return this.color >> 16 & 0xFF;
    }

    public int getIntG() {
        return this.color >> 8 & 0xFF;
    }

    public int getIntB() {
        return this.color >> 0 & 0xFF;
    }

    public int getIntA() {
        return this.color >> 24 & 0xFF;
    }

    public int getColor() {
        return this.color;
    }

    public float getFloatR() {
        return (float)this.getIntR() / 255.0f;
    }

    public float getFloatG() {
        return (float)this.getIntG() / 255.0f;
    }

    public float getFloatB() {
        return (float)this.getIntB() / 255.0f;
    }

    public float getFloatA() {
        return (float)this.getIntA() / 255.0f;
    }

    @Override
    public int intValue() {
        return this.color;
    }

    @Override
    public long longValue() {
        return this.color;
    }

    @Override
    public float floatValue() {
        return this.color;
    }

    @Override
    public double doubleValue() {
        return this.color;
    }
}

