/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render;

import java.util.HashMap;
import java.util.Map;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;

public class HoloIcons {
    Map<String, HoloIcon> iconMap;
    public TextureMap textureMap;
    public int sheetSize = 256;
    public ResourceLocation sheet = new ResourceLocation("mo", "textures/gui/holo_icons.png");

    public HoloIcons() {
        this.iconMap = new HashMap<String, HoloIcon>();
        this.textureMap = new TextureMap(4, "textures/gui/items");
        Minecraft.func_71410_x().field_71446_o.func_130088_a(this.sheet, this.textureMap);
    }

    public void registerIcons(TextureMap textureMap) {
        this.reg("holo_home", 14);
        this.reg("holo_dotted_circle", 20);
        this.reg("holo_factory", 14);
        this.reg("person", 18);
        this.reg("android_slot_arms", 16);
        this.reg("android_slot_chest", 16);
        this.reg("android_slot_head", 16);
        this.reg("android_slot_legs", 16);
        this.reg("android_slot_other", 16);
        this.reg("barrel", 16);
        this.reg("battery", 16);
        this.reg("color", 16);
        this.reg("factory", 16);
        this.reg("module", 16);
        this.reg("sights", 16);
        this.reg("shielding", 16);
        this.reg("scanner", 16);
        this.reg("upgrade", 16);
        this.reg("decompose", 16);
        this.reg("pattern_storage", 16);
        this.reg("home_icon", 14);
        this.reg("page_icon_home", 14);
        this.reg("page_icon_tasks", 15);
        this.reg("page_icon_upgrades", 12);
        this.reg("page_icon_config", 16);
        this.reg("page_icon_search", 16);
        this.reg("page_icon_info", 16);
        this.reg("page_icon_galaxy", 11);
        this.reg("page_icon_quadrant", 9);
        this.reg("page_icon_star", 12);
        this.reg("page_icon_planet", 16);
        this.reg("energy", 16);
        this.reg("arrow_right", 19);
        this.reg("travel_icon", 18);
        this.reg("icon_search", 16);
        this.reg("icon_size", 16);
        this.reg("icon_shuttle", 16);
        this.reg("icon_size", 16);
        this.reg("icon_stats", 16);
        this.reg("icon_scount_planet", 32);
        this.reg("icon_attack", 16);
        this.reg("up_arrow", 7);
        this.reg("crosshair", 3);
        this.reg("up_arrow_large", 18);
        this.reg("android_feature_icon_bg", 22);
        this.reg("android_feature_icon_bg_active", 22);
        this.reg("health", 18);
        this.reg("black_circle", 18);
        this.reg("connections", 16);
        this.reg("ammo", 18);
        this.reg("temperature", 18);
        this.reg("flash_drive", 16);
        this.reg("trade", 16);
        this.reg("mini_quit", 16);
        this.reg("mini_back", 16);
        this.reg("tick", 16);
        this.reg("list", 16);
        this.reg("grid", 16);
        this.reg("sort_random", 16);
        this.reg("minimap_target", 21);
        this.reg("question_mark", 20);
        this.reg("android_feature_icon_bg_black", 22);
        this.reg("smile", 16);
        MatterOverdrive.statRegistry.registerIcons(this);
    }

    private void reg(String iconName, int originalSize) {
        this.registerIcon(iconName, originalSize);
    }

    public HoloIcon registerIcon(String iconName, int originalSize) {
        HoloIcon holoIcon = new HoloIcon(this.textureMap.func_94245_a("mo:" + iconName), originalSize, originalSize);
        this.iconMap.put(iconName, holoIcon);
        return holoIcon;
    }

    public HoloIcon getIcon(String icon) {
        return this.iconMap.get(icon);
    }

    public void bindSheet() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.sheet);
    }

    public void renderIcon(String name, double x, double y) {
        HoloIcon icon = this.getIcon(name);
        this.renderIcon(icon, x, y, icon.getOriginalWidth(), icon.getOriginalHeight());
    }

    public void renderIcon(String name, double x, double y, int width, int height) {
        this.renderIcon(this.getIcon(name), x, y, width, height);
    }

    public void renderIcon(HoloIcon icon, double x, double y) {
        this.renderIcon(icon, x, y, icon.getOriginalWidth(), icon.getOriginalHeight());
    }

    public void renderIcon(HoloIcon icon, double x, double y, int width, int height) {
        if (icon != null) {
            this.bindSheet();
            RenderUtils.renderIcon(x, y, 0.0, icon.getIcon(), width, height);
        }
    }

    public static void tessalateParticleIcon(IIcon icon, double x, double y, double z, float size, Color color) {
        RenderUtils.tessalateParticle(Minecraft.func_71410_x().field_71451_h, icon, size, Vec3.func_72443_a((double)x, (double)y, (double)z), color);
    }

    public static void tessalateStaticIcon(IIcon icon, double x, double y, double z, float size, Color color) {
        HoloIcons.tessalateStaticIcon(icon, x, y, z, size, color, 1.0f);
    }

    public static void tessalateStaticIcon(IIcon icon, double x, double y, double z, float size, Color color, float multiply) {
        float halfSize = size / 2.0f;
        float uMin = icon.func_94209_e();
        float uMax = icon.func_94212_f();
        float vMin = icon.func_94206_g();
        float vMax = icon.func_94210_h();
        Tessellator.field_78398_a.func_78369_a(color.getFloatR() * multiply, color.getFloatG() * multiply, color.getFloatB() * multiply, color.getFloatA());
        Tessellator.field_78398_a.func_78374_a(x - (double)halfSize, y - (double)halfSize, z, (double)uMax, (double)vMax);
        Tessellator.field_78398_a.func_78374_a(x + (double)halfSize, y - (double)halfSize, z, (double)uMin, (double)vMax);
        Tessellator.field_78398_a.func_78374_a(x + (double)halfSize, y + (double)halfSize, z, (double)uMin, (double)vMin);
        Tessellator.field_78398_a.func_78374_a(x - (double)halfSize, y + (double)halfSize, z, (double)uMax, (double)vMin);
    }
}

