/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import matteroverdrive.Reference;
import matteroverdrive.api.IScannable;
import matteroverdrive.api.inventory.IBlockScanner;
import matteroverdrive.client.RenderHandler;
import matteroverdrive.client.render.IWorldLastRenderer;
import matteroverdrive.client.render.tileentity.TileEntityRendererPatternMonitor;
import matteroverdrive.entity.player.AndroidPlayer;
import matteroverdrive.util.MatterDatabaseHelper;
import matteroverdrive.util.MatterHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderMatterScannerInfoHandler
implements IWorldLastRenderer {
    private DecimalFormat healthFormater = new DecimalFormat("#.##");
    public ResourceLocation spinnerTexture = new ResourceLocation("mo:textures/gui/elements/spinner.png");

    @Override
    public void onRenderWorldLast(RenderHandler renderHandler, RenderWorldLastEvent event) {
        ItemStack heldItem = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        if (heldItem != null && heldItem.func_77973_b() instanceof IBlockScanner && Minecraft.func_71410_x().field_71439_g.func_71039_bw()) {
            GL11.glPushMatrix();
            this.renderInfo((EntityPlayer)Minecraft.func_71410_x().field_71439_g, heldItem, event.partialTicks);
            GL11.glPopMatrix();
        } else if (AndroidPlayer.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).isAndroid()) {
            this.renderInfo((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71476_x, null, event.partialTicks);
        }
    }

    private void renderInfo(EntityPlayer player, ItemStack scanner, float ticks) {
        IBlockScanner scannerItem = (IBlockScanner)scanner.func_77973_b();
        MovingObjectPosition position = scannerItem.getScanningPos(scanner, player);
        this.renderInfo(player, position, scanner, ticks);
    }

    private void renderInfo(EntityPlayer player, MovingObjectPosition position, ItemStack scanner, float ticks) {
        Vec3 playerPos = player.func_70666_h(ticks);
        GL11.glPushAttrib((int)16640);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        if (position != null) {
            if (position.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                Block block = player.field_70170_p.func_147439_a(position.field_72311_b, position.field_72312_c, position.field_72309_d);
                if (block != null) {
                    this.renderBlockInfo(block, position, player, playerPos, scanner, scanner == null);
                }
            } else if (position.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && position.field_72308_g != null) {
                this.renderEntityInfo(position.field_72308_g, position, player, playerPos, ticks);
            }
        }
        GL11.glPopAttrib();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderBlockInfo(Block block, MovingObjectPosition position, EntityPlayer player, Vec3 playerPos, ItemStack scanner, boolean infoOnly) {
        double offset = 0.1;
        ForgeDirection side = ForgeDirection.getOrientation((int)position.field_72310_e);
        ArrayList<String> infos = new ArrayList<String>();
        if (block instanceof IScannable) {
            ((IScannable)block).addInfo(player.field_70170_p, position.field_72311_b, position.field_72312_c, position.field_72309_d, infos);
        } else if (player.field_70170_p.func_147438_o(position.field_72311_b, position.field_72312_c, position.field_72309_d) instanceof IScannable) {
            ((IScannable)player.field_70170_p.func_147438_o(position.field_72311_b, position.field_72312_c, position.field_72309_d)).addInfo(player.field_70170_p, position.field_72311_b, position.field_72312_c, position.field_72309_d, infos);
        } else if (infoOnly) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)side.offsetX * 0.5 + ((double)position.field_72311_b + 0.5) - playerPos.field_72450_a), (double)((double)side.offsetY * 0.5 + ((double)position.field_72312_c + 0.5) - playerPos.field_72448_b), (double)((double)side.offsetZ * 0.5 + ((double)position.field_72309_d + 0.5) - playerPos.field_72449_c));
        RenderMatterScannerInfoHandler.rotateFromSide(side, player.field_70177_z);
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)(-offset));
        this.drawInfoPlane(0.0);
        ItemStack blockItemStack = MatterDatabaseHelper.GetItemStackFromWorld(player.field_70170_p, position.field_72311_b, position.field_72312_c, position.field_72309_d);
        int matter = MatterHelper.getMatterAmountFromItem(blockItemStack);
        if (matter > 0) {
            infos.add("Matter: " + MatterHelper.formatMatter(matter));
        }
        String blockName = "Unknown";
        try {
            blockName = blockItemStack != null ? blockItemStack.func_82833_r() : player.field_70170_p.func_147439_a(position.field_72311_b, position.field_72312_c, position.field_72309_d).func_149732_F();
        }
        catch (Exception e) {
            blockName = player.field_70170_p.func_147439_a(position.field_72311_b, position.field_72312_c, position.field_72309_d).func_149732_F();
        }
        finally {
            this.drawInfoList(blockName, infos);
        }
        if (!(block instanceof IScannable) && scanner != null) {
            this.drawProgressBar(scanner, player);
        }
        GL11.glPopMatrix();
    }

    private void drawProgressBar(ItemStack scanner, EntityPlayer player) {
        GL11.glPushMatrix();
        this.renderer().func_110577_a(this.spinnerTexture);
        int count = player.func_71052_bv();
        int maxCount = scanner.func_77988_m();
        GL11.glAlphaFunc((int)516, (float)((float)count / (float)maxCount));
        RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, 0.5f);
        RenderUtils.drawPlane(0.35, 0.45, -0.1, 0.3, 0.3);
        GL11.glPopMatrix();
    }

    private void renderEntityInfo(Entity entity, MovingObjectPosition position, EntityPlayer player, Vec3 playerPos, float ticks) {
        if (!entity.func_98034_c(player)) {
            double offset = 0.1;
            String name = entity.func_70005_c_();
            ArrayList<String> infos = new ArrayList<String>();
            if (entity instanceof EntityLivingBase) {
                Vec3 entityPos = ((EntityLivingBase)entity).func_70666_h(ticks);
                entityPos.field_72448_b += (double)entity.func_70047_e();
                infos.add("Health: " + this.healthFormater.format(((EntityLivingBase)entity).func_110143_aJ()) + " / " + ((EntityLivingBase)entity).func_110138_aP());
                GL11.glPushMatrix();
                GL11.glTranslated((double)(entityPos.field_72450_a - playerPos.field_72450_a), (double)(entityPos.field_72448_b - playerPos.field_72448_b), (double)(entityPos.field_72449_c - playerPos.field_72449_c));
                GL11.glRotated((double)(player.field_70126_B + (player.field_70177_z - player.field_70126_B) * ticks), (double)0.0, (double)-1.0, (double)0.0);
                GL11.glRotated((double)(player.field_70127_C + (player.field_70125_A - player.field_70127_C) * ticks), (double)1.0, (double)0.0, (double)0.0);
                GL11.glTranslated((double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                GL11.glTranslated((double)-0.5, (double)-0.5, (double)(-offset));
                this.drawInfoPlane(0.5);
                this.drawInfoList(name, infos);
                GL11.glPopMatrix();
            }
        }
    }

    private void drawInfoPlane(double opacity) {
        if (opacity > 0.0) {
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)3553);
            GL11.glColor4d((double)0.0, (double)0.0, (double)0.0, (double)opacity);
            RenderUtils.drawPlane(1.0);
            GL11.glEnable((int)3553);
        }
        GL11.glBlendFunc((int)1, (int)769);
        RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, 0.05f);
        this.renderer().func_110577_a(TileEntityRendererPatternMonitor.screenTextureBack);
        RenderUtils.drawPlane(0.0, 0.0, -0.01, 1.0, 1.0);
    }

    private void drawInfoList(String name, List<String> infos) {
        GL11.glPushMatrix();
        int width = this.fontRenderer().func_78256_a(name);
        GL11.glTranslated((double)0.5, (double)0.5, (double)-0.05);
        GL11.glScaled((double)0.01, (double)0.01, (double)0.01);
        this.fontRenderer().func_78276_b(name, -width / 2, -40, Reference.COLOR_HOLO.getColor());
        for (int i = 0; i < infos.size(); ++i) {
            width = this.fontRenderer().func_78256_a(infos.get(i));
            this.fontRenderer().func_78276_b(infos.get(i), -width / 2, -24 + 16 * i, Reference.COLOR_HOLO.getColor());
        }
        GL11.glPopMatrix();
    }

    public static void rotateFromSide(ForgeDirection side, float yaw) {
        if (side == ForgeDirection.UP) {
            GL11.glRotatef((float)(Math.round(yaw / 90.0f) * 90 - 180), (float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
        } else if (side == ForgeDirection.DOWN) {
            GL11.glRotatef((float)(Math.round(yaw / 90.0f) * 90 - 180), (float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
        } else if (side == ForgeDirection.WEST) {
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        } else if (side == ForgeDirection.EAST) {
            GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        } else if (side == ForgeDirection.NORTH) {
            GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        } else if (side == ForgeDirection.SOUTH) {
            GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        }
    }

    private FontRenderer fontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    private TextureManager renderer() {
        return Minecraft.func_71410_x().field_71446_o;
    }
}

