/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render;

import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import matteroverdrive.client.RenderHandler;
import matteroverdrive.client.render.IWorldLastRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class RenderParticlesHandler
implements IWorldLastRenderer {
    ResourceLocation additiveTextureSheet = new ResourceLocation("mo:textures/particle/particles_additive.png");
    private TextureManager renderer;
    protected World worldObj;
    private Random rand = new Random();
    List<EntityFX>[] fxes;

    public RenderParticlesHandler(World world, TextureManager renderer) {
        this.worldObj = world;
        this.renderer = renderer;
        this.fxes = new List[Blending.values().length];
        for (int i = 0; i < Blending.values().length; ++i) {
            this.fxes[i] = new ArrayList<EntityFX>();
        }
    }

    @Override
    public void onRenderWorldLast(RenderHandler renderHandler, RenderWorldLastEvent event) {
        this.renderParticles((Entity)Minecraft.func_71410_x().field_71439_g, event.partialTicks);
    }

    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!Minecraft.func_71410_x().func_147113_T()) {
            this.updateEffects();
        }
    }

    public void addEffect(EntityFX entityFX, Blending blendingLayer) {
        this.fxes[blendingLayer.ordinal()].add(entityFX);
    }

    private void updateEffects() {
        for (int k = 0; k < this.fxes.length; ++k) {
            for (int j = 0; j < this.fxes[k].size(); ++j) {
                final EntityFX entityfx = this.fxes[k].get(j);
                try {
                    if (entityfx != null) {
                        entityfx.func_70071_h_();
                    }
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Ticking Particle");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being ticked");
                    crashreportcategory.func_71500_a("Particle", new Callable(){
                        private static final String __OBFID = "CL_00000916";

                        public String call() {
                            return entityfx.toString();
                        }
                    });
                    throw new ReportedException(crashreport);
                }
                if (entityfx != null && !entityfx.field_70128_L) continue;
                this.fxes[k].remove(j--);
            }
        }
    }

    public void renderParticles(Entity entity, float f) {
        float f1 = ActiveRenderInfo.field_74588_d;
        float f2 = ActiveRenderInfo.field_74586_f;
        float f3 = ActiveRenderInfo.field_74587_g;
        float f4 = ActiveRenderInfo.field_74596_h;
        float f5 = ActiveRenderInfo.field_74589_e;
        EntityFX.field_70556_an = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)f;
        EntityFX.field_70554_ao = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)f;
        EntityFX.field_70555_ap = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)f;
        for (int k = 0; k < this.fxes.length; ++k) {
            if (this.fxes[k].isEmpty()) continue;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDepthMask((boolean)false);
            GL11.glEnable((int)3042);
            switch (k) {
                case 0: {
                    GL11.glBlendFunc((int)1, (int)1);
                    this.renderer.func_110577_a(this.additiveTextureSheet);
                }
            }
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            for (int j = 0; j < this.fxes[k].size(); ++j) {
                EntityFX entityfx = this.fxes[k].get(j);
                if (entityfx == null) continue;
                tessellator.func_78380_c(entityfx.func_70070_b(f));
                try {
                    entityfx.func_70539_a(tessellator, f, f1, f5, f2, f3, f4);
                    continue;
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering Particle");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being rendered");
                    crashreportcategory.func_71500_a("Particle", () -> ((EntityFX)entityfx).toString());
                    throw new ReportedException(crashreport);
                }
            }
            tessellator.func_78381_a();
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
            GL11.glAlphaFunc((int)516, (float)0.1f);
        }
    }

    public ResourceLocation getAdditiveTextureSheet() {
        return this.additiveTextureSheet;
    }

    public static enum Blending {
        Additive;

    }
}

