/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import matteroverdrive.init.MatterOverdriveIcons;
import matteroverdrive.util.RenderUtils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public class RendererBlockInscriber
implements ISimpleBlockRenderingHandler {
    public static int renderID;
    private IModelCustom model;

    public RendererBlockInscriber() {
        renderID = RenderingRegistry.getNextAvailableRenderId();
        this.model = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("mo:models/block/inscriber.obj"));
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        Tessellator.field_78398_a.func_78371_b(4);
        Matrix4f mat = new Matrix4f();
        mat.translate(new Vector3f(-0.5f, -0.5f, -0.5f));
        this.renderBlock(mat, 0, 0, 0, -1, block.func_149635_D());
        Tessellator.field_78398_a.func_78381_a();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        Matrix4f rot = new Matrix4f();
        rot.translate(new Vector3f(0.0f, 0.0f, 0.0f));
        RenderUtils.rotateFromBlock(rot, world, x, y, z);
        this.renderBlock(rot, x, y, z, block.func_149677_c(world, x, y, z), block.func_149635_D());
        return true;
    }

    protected void renderBlock(Matrix4f mat, int x, int y, int z, int brightness, int color) {
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78371_b(4);
        GroupObject base = (GroupObject)((WavefrontObject)this.model).groupObjects.get(0);
        RenderUtils.tesseleteModelAsBlock(mat, base, MatterOverdriveIcons.inscriber, x, y, z, brightness, true, null);
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78382_b();
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return renderID;
    }
}

