/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.item;

import java.util.Random;
import matteroverdrive.client.render.item.WeaponItemRenderer;
import matteroverdrive.handler.weapon.ClientWeaponHandler;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.WeaponHelper;
import matteroverdrive.util.animation.MOEasing;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRendererIonSniper
extends WeaponItemRenderer {
    public static final String TEXTURE = "mo:textures/items/ion_sniper.png";
    public static final String MODEL = "mo:models/item/ion_sniper.obj";
    public static final float SCALE = 0.06f;
    public static final float THIRD_PERSON_SCALE = 0.048f;
    public static final float ITEM_SCALE = 0.015f;
    public static final float SCALE_DROP = 0.03f;
    private Random random = new Random();
    private Vec3 scopePosition;

    public ItemRendererIonSniper() {
        super(new ResourceLocation(MODEL), new ResourceLocation(TEXTURE));
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            this.renderFirstPerson(item);
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.renderItem(item);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            this.renderDrop(item);
        } else {
            this.renderThirdPerson(type, item);
        }
    }

    void renderItem(ItemStack item) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.6);
        GL11.glRotated((double)0.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glScaled((double)0.015f, (double)0.015f, (double)0.015f);
        this.renderGun(IItemRenderer.ItemRenderType.INVENTORY, item);
        GL11.glPopMatrix();
    }

    void renderThirdPerson(IItemRenderer.ItemRenderType renderType, ItemStack item) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)1.0, (double)0.83, (double)1.0);
        GL11.glRotated((double)-135.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)60.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glScaled((double)0.048f, (double)0.048f, (double)0.048f);
        this.renderGun(renderType, item);
        GL11.glPopMatrix();
    }

    void renderDrop(ItemStack item) {
        GL11.glPushMatrix();
        GL11.glScaled((double)0.03f, (double)0.03f, (double)0.03f);
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.7);
        this.renderGun(IItemRenderer.ItemRenderType.ENTITY, item);
        GL11.glPopMatrix();
    }

    void renderFirstPerson(ItemStack item) {
        ClientProxy.instance().getClientWeaponHandler();
        float zoomValue = MOEasing.Sine.easeInOut(ClientWeaponHandler.ZOOM_TIME, 0.0f, 1.0f, 1.0f);
        float recoilValue = MOEasing.Quart.easeInOut(this.getRecoilTime(), 0.0f, 1.0f, 1.0f);
        GL11.glPushMatrix();
        ResourceLocation skin = Minecraft.func_71410_x().field_71439_g.func_110306_p();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(skin);
        Minecraft.func_71410_x().field_71451_h.field_70125_A = (float)((double)Minecraft.func_71410_x().field_71451_h.field_70125_A + ((double)recoilValue * this.random.nextGaussian() * (double)0.1f - (double)((1.0f - zoomValue * 0.5f) * recoilValue * this.getRecoilAmount() * 0.2f)));
        Minecraft.func_71410_x().field_71451_h.field_70177_z = (float)((double)Minecraft.func_71410_x().field_71451_h.field_70177_z + (double)(recoilValue * 0.05f) * this.random.nextGaussian());
        GL11.glTranslated((double)2.0, (double)MOMathHelper.Lerp(-0.3f, -0.5f, zoomValue), (double)MOMathHelper.Lerp(-1.0f, -1.1f, zoomValue));
        GL11.glTranslatef((float)0.0f, (float)(recoilValue * 0.05f * this.getRecoilAmount()), (float)0.0f);
        GL11.glRotated((double)MOMathHelper.Lerp(45.0f, 0.0f, zoomValue), (double)1.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)MOMathHelper.Lerp(0.0f, MOMathHelper.Lerp(3.0f, 0.0f, zoomValue), recoilValue), (double)0.0, (double)0.0, (double)1.0);
        double length = 1.8;
        double width = 0.6;
        double depth = 0.5;
        if (!Minecraft.func_71410_x().field_71439_g.func_82150_aj()) {
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
            Tessellator.field_78398_a.func_78374_a(0.0, 0.0, 0.0, 0.6875, 0.625);
            Tessellator.field_78398_a.func_78374_a(0.0, length, 0.0, 0.6875, 1.0);
            Tessellator.field_78398_a.func_78374_a(depth, length, 0.0, 0.75, 1.0);
            Tessellator.field_78398_a.func_78374_a(depth, 0.0, 0.0, 0.75, 0.625);
            Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
            Tessellator.field_78398_a.func_78374_a(0.0, 0.0, 0.0, 0.6875, 0.625);
            Tessellator.field_78398_a.func_78374_a(0.0, 0.0, width, 0.625, 0.625);
            Tessellator.field_78398_a.func_78374_a(0.0, length, width, 0.625, 1.0);
            Tessellator.field_78398_a.func_78374_a(0.0, length, 0.0, 0.6875, 1.0);
            Tessellator.field_78398_a.func_78381_a();
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotated((double)MOMathHelper.Lerp(30.0f, 25.0f, zoomValue), (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)MOMathHelper.Lerp(90.0f, 85.0f, zoomValue), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)MOMathHelper.Lerp(0.0f, 1.0f, zoomValue), (double)MOMathHelper.Lerp(-0.4f, -0.1f + this.getScopeOffset(item), zoomValue), (double)MOMathHelper.Lerp(1.2f, 0.6f, zoomValue));
        GL11.glScaled((double)1.0, (double)1.0, (double)0.6);
        GL11.glTranslatef((float)0.0f, (float)(-recoilValue * 0.05f * this.getRecoilAmount()), (float)(-recoilValue * 0.05f * this.getRecoilAmount()));
        GL11.glRotated((double)(recoilValue * 2.0f * this.getRecoilAmount()), (double)-1.0, (double)0.0, (double)0.0);
        GL11.glScaled((double)0.06f, (double)0.06f, (double)0.06f);
        this.renderGun(IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON, item);
        GL11.glPopMatrix();
    }

    void renderGun(IItemRenderer.ItemRenderType renderType, ItemStack item) {
        RenderUtils.applyColor(WeaponHelper.getColor(item));
        this.renderScope(item);
        this.bindTexture(this.weaponTexture);
        this.weaponModel.renderAll();
    }
}

