/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.item;

import java.io.IOException;
import matteroverdrive.api.weapon.IWeaponModule;
import matteroverdrive.api.weapon.IWeaponScope;
import matteroverdrive.client.resources.data.WeaponMetadataSection;
import matteroverdrive.handler.weapon.ClientWeaponHandler;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.WeaponHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.lwjgl.opengl.GL11;

public abstract class WeaponItemRenderer
implements IItemRenderer {
    protected ResourceLocation weaponTexture;
    protected ResourceLocation weaponModelLocation;
    protected WavefrontObject weaponModel;
    protected Vec3 scopePosition;

    public WeaponItemRenderer(ResourceLocation weaponModelLocation, ResourceLocation weaponTexture) {
        this.weaponModelLocation = weaponModelLocation;
        this.weaponTexture = weaponTexture;
        this.weaponModel = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)weaponModelLocation);
        this.loadWeaponMetadata();
    }

    protected void loadWeaponMetadata() {
        try {
            IMetadataSection section;
            IResource metadataResource = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.weaponModelLocation);
            if (metadataResource.func_110528_c() && (section = metadataResource.func_110526_a("weapon")) instanceof WeaponMetadataSection) {
                this.scopePosition = ((WeaponMetadataSection)section).getScopePosition();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void renderBarrel(ItemStack weaponStack) {
        GroupObject object;
        this.bindTexture(this.weaponTexture);
        ItemStack barrelStack = WeaponHelper.getModuleAtSlot(2, weaponStack);
        if (barrelStack != null && (object = this.getModelPart(barrelStack.func_77977_a().substring(5).replace('.', '_'))) != null) {
            object.render();
            return;
        }
        this.renderDefaultBarrel(weaponStack);
    }

    protected void renderScope(ItemStack weapon) {
        ItemStack scopeStack = WeaponHelper.getModuleAtSlot(3, weapon);
        if (scopeStack != null && scopeStack.func_77973_b() instanceof IWeaponModule) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)this.scopePosition.field_72450_a, (double)this.scopePosition.field_72448_b, (double)this.scopePosition.field_72449_c);
            String moduleObjectName = ((IWeaponModule)scopeStack.func_77973_b()).getModelName(scopeStack);
            WavefrontObject model = ClientProxy.renderHandler.getWeaponModuleModelRegistry().getModel(((IWeaponModule)scopeStack.func_77973_b()).getModelPath());
            ResourceLocation moduleTexture = ((IWeaponModule)scopeStack.func_77973_b()).getModelTexture(scopeStack);
            if (moduleTexture != null) {
                this.bindTexture(moduleTexture);
            } else {
                this.bindTexture(this.weaponTexture);
            }
            if (model != null) {
                for (GroupObject object : model.groupObjects) {
                    if (!object.name.equalsIgnoreCase(moduleObjectName + "_window")) continue;
                    RenderUtils.disableLightmap();
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)1, (int)1);
                    GL11.glDepthFunc((int)515);
                    GL11.glEnable((int)2929);
                    GL11.glDepthMask((boolean)true);
                    object.render();
                    RenderUtils.enableLightmap();
                    GL11.glDisable((int)3042);
                    break;
                }
                model.renderOnly(new String[]{moduleObjectName});
            }
            GL11.glPopMatrix();
        }
    }

    protected void renderModule(IWeaponModule weaponModule, ItemStack weaponModuleStack, ItemStack weaponStack) {
        WavefrontObject model = ClientProxy.renderHandler.getWeaponModuleModelRegistry().getModel(weaponModule.getModelPath());
        if (model != null) {
            ResourceLocation moduleTexture = weaponModule.getModelTexture(weaponModuleStack);
            if (moduleTexture != null) {
                this.bindTexture(moduleTexture);
            } else {
                this.bindTexture(this.weaponTexture);
            }
            String moduleObjectName = weaponModule.getModelName(weaponModuleStack);
            model.renderOnly(new String[]{moduleObjectName});
        }
    }

    public float getScopeOffset(ItemStack weapon) {
        ItemStack scopeStack = WeaponHelper.getModuleAtSlot(3, weapon);
        if (scopeStack != null && scopeStack.func_77973_b() instanceof IWeaponScope) {
            return ((IWeaponScope)scopeStack.func_77973_b()).getYOffset(scopeStack, weapon);
        }
        return 0.0f;
    }

    protected void renderDefaultBarrel(ItemStack weaponStack) {
        this.weaponModel.renderPart("weapon_module_barrel_none");
    }

    protected void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
    }

    protected GroupObject getModelPart(String part) {
        for (GroupObject object : this.weaponModel.groupObjects) {
            if (!object.name.equalsIgnoreCase(part)) continue;
            return object;
        }
        return null;
    }

    public ResourceLocation getWeaponTexture() {
        return this.weaponTexture;
    }

    public float getRecoilTime() {
        return ClientWeaponHandler.RECOIL_TIME;
    }

    public float getRecoilAmount() {
        return ClientWeaponHandler.RECOIL_AMOUNT;
    }
}

