/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.tileentity;

import java.util.ArrayList;
import matteroverdrive.Reference;
import matteroverdrive.tile.TileEntityGravitationalAnomaly;
import matteroverdrive.tile.TileEntityMachineGravitationalStabilizer;
import matteroverdrive.util.MOBlockHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class TileEntityRendererGravitationalStabilizer
extends TileEntitySpecialRenderer {
    public static final ResourceLocation beam = new ResourceLocation("mo:textures/fx/physbeam.png");

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float ticks) {
        TileEntityMachineGravitationalStabilizer stabilizer = (TileEntityMachineGravitationalStabilizer)tileEntity;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ForgeDirection f = ForgeDirection.getOrientation((int)tileEntity.func_145831_w().func_72805_g(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e));
        if (stabilizer.getHit() != null) {
            MovingObjectPosition hit = stabilizer.getHit();
            TileEntity tileEntityHit = tileEntity.func_145831_w().func_147438_o(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            long time = stabilizer.func_145831_w().func_72820_D();
            double pulseSize = Math.sin((double)time * 0.2) * 0.001;
            Vector3f source = new Vector3f((float)tileEntity.field_145851_c, (float)tileEntity.field_145848_d, (float)tileEntity.field_145849_e);
            Vector3f destination = new Vector3f((float)hit.field_72307_f.field_72450_a, (float)hit.field_72307_f.field_72448_b, (float)hit.field_72307_f.field_72449_c);
            Vector3f dir = Vector3f.sub((Vector3f)destination, (Vector3f)source, null);
            Vector3f dirC = Vector3f.cross((Vector3f)dir, (Vector3f)new Vector3f(1.0f, 0.0f, 1.0f), null);
            float distance = dir.length();
            dir.normalise(dir);
            Vector3f front = new Vector3f(0.0f, 0.0f, -1.0f);
            Vector3f c = Vector3f.cross((Vector3f)dir, (Vector3f)front, null);
            double omega = Math.acos(Vector3f.dot((Vector3f)dir, (Vector3f)front));
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)2896);
            RenderUtils.disableLightmap();
            GL11.glBlendFunc((int)1, (int)1);
            GL11.glColor3d((double)stabilizer.getBeamColorR(), (double)stabilizer.getBeamColorG(), (double)stabilizer.getBeamColorB());
            this.func_147499_a(beam);
            GL11.glPushMatrix();
            GL11.glScaled((double)((double)dirC.x * pulseSize + 1.0), (double)((double)dirC.y * pulseSize + 1.0), (double)((double)dirC.z * pulseSize + 1.0));
            GL11.glTranslated((double)(dir.x * distance / 2.0f), (double)(dir.y * distance / 2.0f), (double)(dir.z * distance / 2.0f));
            GL11.glScaled((double)(dir.x * distance + 1.0f), (double)(dir.y * distance + 1.0f), (double)(dir.z * distance + 1.0f));
            GL11.glRotated((double)(omega * 57.29577951308232), (double)c.x, (double)c.y, (double)c.z);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)0.0);
            RenderUtils.drawPlaneWithUV(1.0, 1.0, 0.0, 0.0, distance / 2.0f, 1.0);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslated((double)(dir.x * distance / 2.0f), (double)(dir.y * distance / 2.0f), (double)(dir.z * distance / 2.0f));
            GL11.glScaled((double)(destination.x - source.x + 1.0f), (double)(destination.y - source.y + 1.0f), (double)(destination.z - source.z + 1.0f));
            GL11.glRotated((double)(omega * 57.29577951308232), (double)c.x, (double)c.y, (double)c.z);
            GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)0.0);
            RenderUtils.drawPlaneWithUV(1.0, 1.0, 0.0, 0.0, distance / 2.0f, 1.0);
            GL11.glPopMatrix();
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            RenderUtils.enableLightmap();
            GL11.glPopMatrix();
            if (tileEntityHit != null && tileEntityHit instanceof TileEntityGravitationalAnomaly) {
                this.renderScreen(x, y, z, stabilizer, (TileEntityGravitationalAnomaly)tileEntityHit);
            }
        }
    }

    public void renderScreen(double x, double y, double z, TileEntityMachineGravitationalStabilizer stabilizer, TileEntityGravitationalAnomaly anomaly) {
        int meta = stabilizer.func_145831_w().func_72805_g(stabilizer.field_145851_c, stabilizer.field_145848_d, stabilizer.field_145849_e);
        ForgeDirection side = ForgeDirection.getOrientation((int)MOBlockHelper.getOppositeSide(meta));
        RenderUtils.beginDrawinngBlockScreen(x, y, z, side, Reference.COLOR_HOLO, stabilizer);
        ArrayList<String> infos = new ArrayList<String>();
        anomaly.addInfo(anomaly.func_145831_w(), anomaly.field_145851_c, anomaly.field_145848_d, anomaly.field_145849_e, infos);
        RenderUtils.drawScreenInfoWithGlobalAutoSize(infos.toArray(new String[infos.size()]), Reference.COLOR_HOLO, side, 10, 10, 4.0f);
        RenderUtils.endDrawinngBlockScreen();
    }

    private FontRenderer fontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }
}

