/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.tileentity;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import matteroverdrive.Reference;
import matteroverdrive.client.data.Color;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;

public abstract class TileEntityRendererStation<T extends MOTileEntityMachine>
extends TileEntitySpecialRenderer
implements IConfigSubscriber {
    public static ResourceLocation glowTexture = new ResourceLocation("mo:textures/fx/hologram_beam.png");
    ResourceLocation holo_shader_vert_loc = new ResourceLocation("mo:shaders/holo_shader.vert");
    ResourceLocation holo_shader_frag_loc = new ResourceLocation("mo:shaders/holo_shader.frag");
    String holo_shader_vert;
    String holo_shader_frag;
    protected int shaderProgram;
    protected boolean validShader = true;
    private boolean enableHoloShader = true;
    int vertexShader;
    int fragmentShader;
    Random fliker;
    protected Color holoColor = Reference.COLOR_HOLO.multiplyWithoutAlpha(0.25f);
    protected Color red_holoColor = Reference.COLOR_HOLO_RED.multiplyWithoutAlpha(0.25f);

    public TileEntityRendererStation() {
        this.fliker = new Random();
        if (GLContext.getCapabilities().OpenGL20) {
            this.loadShader();
        } else {
            this.validShader = false;
            MOLog.warn("Your machine does not support OpenGL 2.0. The holographic shader will be disabled.", new Object[0]);
        }
    }

    private void loadShader() {
        InputStream descriptionStream;
        this.shaderProgram = GL20.glCreateProgram();
        this.vertexShader = GL20.glCreateShader((int)35633);
        this.fragmentShader = GL20.glCreateShader((int)35632);
        try {
            descriptionStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.holo_shader_vert_loc).func_110527_b();
            this.holo_shader_vert = IOUtils.toString((InputStream)descriptionStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            descriptionStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.holo_shader_frag_loc).func_110527_b();
            this.holo_shader_frag = IOUtils.toString((InputStream)descriptionStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            GL20.glShaderSource((int)this.vertexShader, (CharSequence)this.holo_shader_vert);
            GL20.glCompileShader((int)this.vertexShader);
            GL20.glShaderSource((int)this.fragmentShader, (CharSequence)this.holo_shader_frag);
            GL20.glCompileShader((int)this.fragmentShader);
            GL20.glAttachShader((int)this.shaderProgram, (int)this.vertexShader);
            GL20.glAttachShader((int)this.shaderProgram, (int)this.fragmentShader);
            GL20.glLinkProgram((int)this.shaderProgram);
            if (GL20.glGetProgrami((int)this.vertexShader, (int)35714) == 0) {
                System.out.println("Could not link shader");
                System.out.println(GL20.glGetProgramInfoLog((int)this.vertexShader, (int)GL20.glGetProgrami((int)this.vertexShader, (int)35716)));
                this.validShader = false;
            }
            GL20.glValidateProgram((int)this.shaderProgram);
            if (GL20.glGetProgrami((int)this.vertexShader, (int)35715) == 0) {
                System.out.println("Could not validate shader");
                System.out.println(GL20.glGetProgramInfoLog((int)this.vertexShader, (int)GL20.glGetProgrami((int)this.vertexShader, (int)35716)));
                this.validShader = false;
            }
            if (GL20.glGetShaderi((int)this.vertexShader, (int)35713) == 0) {
                System.out.println("Could not compile shader");
                this.validShader = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.validShader = false;
        }
    }

    private void drawHoloLights(TileEntity entity, World world, double x, double y, double z, double t) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glDepthMask((boolean)false);
        RenderUtils.disableLightmap();
        GL11.glDisable((int)2884);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(glowTexture);
        double height = 0.5625;
        double hologramHeight = this.getLightHeight();
        double topSize = this.getLightsSize() - 1.0;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)(y + height), (double)z);
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78369_a(this.getHoloColor(entity).getFloatR(), this.getHoloColor(entity).getFloatG(), this.getHoloColor(entity).getFloatB(), 1.0f);
        Tessellator.field_78398_a.func_78374_a(0.0, 0.0, 0.0, 1.0, 1.0);
        Tessellator.field_78398_a.func_78374_a(-topSize, hologramHeight, -topSize, 1.0, 0.0);
        Tessellator.field_78398_a.func_78374_a(1.0 + topSize, hologramHeight, -topSize, 0.0, 0.0);
        Tessellator.field_78398_a.func_78374_a(1.0, 0.0, 0.0, 0.0, 1.0);
        Tessellator.field_78398_a.func_78374_a(1.0, 0.0, 0.0, 1.0, 1.0);
        Tessellator.field_78398_a.func_78374_a(1.0 + topSize, hologramHeight, -topSize, 1.0, 0.0);
        Tessellator.field_78398_a.func_78374_a(1.0 + topSize, hologramHeight, 1.0 + topSize, 0.0, 0.0);
        Tessellator.field_78398_a.func_78374_a(1.0, 0.0, 1.0, 0.0, 1.0);
        Tessellator.field_78398_a.func_78374_a(1.0, 0.0, 1.0, 1.0, 1.0);
        Tessellator.field_78398_a.func_78374_a(1.0 + topSize, hologramHeight, 1.0 + topSize, 1.0, 0.0);
        Tessellator.field_78398_a.func_78374_a(-topSize, hologramHeight, 1.0 + topSize, 0.0, 0.0);
        Tessellator.field_78398_a.func_78374_a(0.0, 0.0, 1.0, 0.0, 1.0);
        Tessellator.field_78398_a.func_78374_a(0.0, 0.0, 1.0, 1.0, 1.0);
        Tessellator.field_78398_a.func_78374_a(-topSize, hologramHeight, 1.0 + topSize, 1.0, 0.0);
        Tessellator.field_78398_a.func_78374_a(-topSize, hologramHeight, -topSize, 0.0, 0.0);
        Tessellator.field_78398_a.func_78374_a(0.0, 0.0, 0.0, 0.0, 1.0);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glPopMatrix();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        RenderUtils.enableLightmap();
    }

    protected double getLightHeight() {
        return 1.0;
    }

    protected double getLightsSize() {
        return 1.3;
    }

    protected Color getHoloColor(TileEntity entity) {
        if (((MOTileEntityMachine)entity).func_70300_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            return this.holoColor;
        }
        return this.red_holoColor;
    }

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float ticks) {
        double t = MOMathHelper.noise((double)tileEntity.field_145851_c * 0.3, (double)tileEntity.field_145848_d * 0.3, (double)tileEntity.field_145849_e * 0.3);
        try {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)16384);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)1, (int)1);
            try {
                this.renderHologram((MOTileEntityMachine)tileEntity, x, y, z, ticks, t);
            }
            catch (ClassCastException e) {
                MOLog.warn("Could not cast to desired station class", e);
            }
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
        catch (Exception e) {
            MOLog.warn("Error while render a station", e);
        }
        if (this.drawHoloLights()) {
            this.drawHoloLights(tileEntity, tileEntity.func_145831_w(), x, y, z, ticks);
        }
    }

    protected boolean drawHoloLights() {
        return true;
    }

    protected void beginHolo(T tileEntity) {
        if (this.validShader && this.enableHoloShader) {
            GL20.glUseProgram((int)this.shaderProgram);
            GL20.glUniform4f((int)0, (float)this.getHoloColor((TileEntity)tileEntity).getFloatR(), (float)this.getHoloColor((TileEntity)tileEntity).getFloatG(), (float)this.getHoloColor((TileEntity)tileEntity).getFloatB(), (float)0.0f);
        } else {
            GL11.glEnable((int)3008);
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
        }
    }

    protected void endHolo() {
        if (this.validShader) {
            GL20.glUseProgram((int)0);
        }
    }

    protected void rotate(T station, double noise) {
        GL11.glRotated((double)((double)Minecraft.func_71410_x().field_71441_e.func_72820_D() * 0.5 + 1800.0 * noise), (double)0.0, (double)-1.0, (double)0.0);
    }

    protected boolean isUsable(T station) {
        return ((MOTileEntityMachine)station).func_70300_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    protected void renderHologram(T station, double x, double y, double z, float partialTicks, double noise) {
        if (!this.isUsable(station)) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.8), (double)(z + 0.5));
            this.rotate(station, noise);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)2896);
            GL11.glScaled((double)0.02, (double)0.02, (double)0.02);
            GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
            Color color = Reference.COLOR_HOLO_RED.multiplyWithoutAlpha(0.33f);
            String[] info = MOStringHelper.translateToLocal("gui.hologram.access_denied").split(" ");
            for (int i = 0; i < info.length; ++i) {
                int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(info[i]);
                GL11.glPushMatrix();
                GL11.glTranslated((double)(-width / 2), (double)-32.0, (double)0.0);
                Minecraft.func_71410_x().field_71466_p.func_78276_b(info[i], 0, i * 10, color.getColor());
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        this.enableHoloShader = config.getBool("use holo shader", "client", true, "Use the custom holo shader for holographic items");
    }
}

