/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.compat;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import matteroverdrive.compat.Compat;
import matteroverdrive.compat.modules.CompatEnderIO;
import matteroverdrive.compat.modules.CompatExNihilo;
import matteroverdrive.compat.modules.CompatMFR;
import matteroverdrive.compat.modules.CompatTConstruct;
import matteroverdrive.compat.modules.CompatThermalExpansion;
import matteroverdrive.compat.modules.computercraft.CompatComputerCraft;
import matteroverdrive.compat.modules.nei.CompatNEI;
import matteroverdrive.compat.modules.waila.CompatWaila;
import matteroverdrive.util.MOLog;

public class MatterOverdriveCompat {
    private static ArrayList<Class> modules = new ArrayList();

    public static void registerModules() {
        MatterOverdriveCompat.register(CompatThermalExpansion.class);
        MatterOverdriveCompat.register(CompatExNihilo.class);
        MatterOverdriveCompat.register(CompatEnderIO.class);
        MatterOverdriveCompat.register(CompatComputerCraft.class);
        MatterOverdriveCompat.register(CompatTConstruct.class);
        MatterOverdriveCompat.register(CompatMFR.class);
    }

    public static void registerClientModules() {
        MatterOverdriveCompat.register(CompatNEI.class);
        MatterOverdriveCompat.register(CompatWaila.class);
    }

    private static boolean register(Class clazz) {
        if (clazz.isAnnotationPresent(Compat.class)) {
            Compat annotation = clazz.getAnnotation(Compat.class);
            if (Loader.isModLoaded((String)annotation.value())) {
                modules.add(clazz);
                return true;
            }
            MOLog.info("The mod %s was not loaded, skipping compatibility module.", annotation.value());
            return false;
        }
        MOLog.error("There was a problem register a compatibility module!", new Object[0]);
        return false;
    }

    public static void preInit(FMLPreInitializationEvent event) {
        MOLog.info("Attempting to run pre-initialization methods for all registered compatibility modules.", new Object[0]);
        for (Class clazz : modules) {
            for (Method m : clazz.getMethods()) {
                if (!m.isAnnotationPresent(Compat.PreInit.class) || !Modifier.isStatic(m.getModifiers())) continue;
                try {
                    m.invoke(null, event);
                }
                catch (ReflectiveOperationException e) {
                    Compat annotation = clazz.getAnnotation(Compat.class);
                    MOLog.error(String.format("There was an error trying to invoke the pre-initialization method of the compatibility module for %1$s", annotation.value()), e, new Object[0]);
                }
            }
        }
    }

    public static void init(FMLInitializationEvent event) {
        MOLog.info("Attempting to run initialization methods for all registered compatibility modules.", new Object[0]);
        for (Class clazz : modules) {
            for (Method m : clazz.getMethods()) {
                if (!m.isAnnotationPresent(Compat.Init.class) || !Modifier.isStatic(m.getModifiers())) continue;
                try {
                    m.invoke(null, event);
                }
                catch (ReflectiveOperationException e) {
                    Compat annotation = clazz.getAnnotation(Compat.class);
                    MOLog.error(String.format("There was an error trying to invoke the initialization method of the compatibility module for %1$s", annotation.value()), e, new Object[0]);
                }
            }
        }
    }

    public static void postInit(FMLPostInitializationEvent event) {
        MOLog.info("Attempting to run post-initialization methods for all registered compatibility modules.", new Object[0]);
        for (Class clazz : modules) {
            for (Method m : clazz.getMethods()) {
                if (!m.isAnnotationPresent(Compat.PostInit.class) || !Modifier.isStatic(m.getModifiers())) continue;
                try {
                    m.invoke(null, event);
                }
                catch (ReflectiveOperationException e) {
                    Compat annotation = clazz.getAnnotation(Compat.class);
                    MOLog.error(String.format("There was an error trying to invoke the post-initialization method of the compatibility module %1$s", annotation.value()), e, new Object[0]);
                }
            }
        }
    }
}

