/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import matteroverdrive.data.IUsableCondition;
import matteroverdrive.data.inventory.Slot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class Inventory
implements IInventory {
    List<Slot> slots;
    String name;
    IUsableCondition usableCondition;

    public Inventory(String name) {
        this(name, new ArrayList<Slot>());
    }

    public Inventory(String name, Collection<Slot> slots) {
        this(name, slots, null);
    }

    public Inventory(String name, Collection<Slot> slots, IUsableCondition usableCondition) {
        this.slots = new ArrayList<Slot>(slots);
        this.name = name;
        this.usableCondition = usableCondition;
    }

    public int AddSlot(Slot slot) {
        if (this.slots.add(slot)) {
            slot.setId(this.slots.size() - 1);
            return this.slots.size() - 1;
        }
        return 0;
    }

    public void setUsableCondition(IUsableCondition condition) {
        this.usableCondition = condition;
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (nbttagcompound1.func_150297_b("id", 2)) {
                this.func_70299_a(b0, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
                continue;
            }
            this.func_70299_a(b0, null);
        }
    }

    public void writeToNBT(NBTTagCompound compound, boolean toDisk) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.writeSlotToNBT(nbttaglist, i, toDisk);
        }
        if (nbttaglist.func_74745_c() > 0) {
            compound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
    }

    protected void writeSlotToNBT(NBTTagList nbttaglist, int slotId, boolean toDisk) {
        Slot slot = this.getSlot(slotId);
        if (slot != null) {
            if (toDisk && slot.getItem() != null) {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("Slot", (byte)slotId);
                if (slot.getItem() != null) {
                    slot.getItem().func_77955_b(nbttagcompound1);
                }
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            } else if (!toDisk && slot.sendsToClient()) {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("Slot", (byte)slotId);
                if (slot.getItem() != null) {
                    slot.getItem().func_77955_b(nbttagcompound1);
                }
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
        }
    }

    public int func_70302_i_() {
        return this.slots.size();
    }

    public ItemStack func_70301_a(int slot) {
        return this.slots.get(slot).getItem();
    }

    public ItemStack func_70298_a(int slotId, int size) {
        Slot slot = this.getSlot(slotId);
        if (slot != null && slot.getItem() != null) {
            if (slot.getItem().field_77994_a <= size) {
                ItemStack itemstack = slot.getItem();
                slot.setItem(null);
                return itemstack;
            }
            ItemStack itemstack = slot.getItem().func_77979_a(size);
            if (slot.getItem().field_77994_a == 0) {
                slot.setItem(null);
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.slots.get(slot) != null) {
            ItemStack itemstack = this.getSlot(slot).getItem();
            this.slots.set(slot, null);
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack item) {
        this.getSlot(slot).setItem(item);
        if (item != null && item.field_77994_a > this.func_70297_j_()) {
            item.field_77994_a = this.func_70297_j_();
        }
    }

    public void addItem(ItemStack itemStack) {
        for (int i = 0; i < this.slots.size(); ++i) {
            Slot slot = this.getSlot(i);
            if (!slot.isValidForSlot(itemStack)) continue;
            if (slot.getItem() == null) {
                slot.setItem(itemStack);
                return;
            }
            if (!ItemStack.func_77989_b((ItemStack)slot.getItem(), (ItemStack)itemStack) || slot.getItem().field_77994_a >= slot.getItem().func_77976_d()) continue;
            int newStackSize = Math.min(slot.getItem().field_77994_a + itemStack.field_77994_a, slot.getItem().func_77976_d());
            int leftStackSize = slot.getItem().field_77994_a + itemStack.field_77994_a - newStackSize;
            slot.getItem().field_77994_a = newStackSize;
            if (leftStackSize <= 0) {
                return;
            }
            itemStack.field_77994_a = newStackSize;
        }
    }

    public void clearItems() {
        for (Slot slot : this.slots) {
            slot.setItem(null);
        }
    }

    public String func_145825_b() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return this.name != null && !this.name.isEmpty();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slotID, ItemStack item) {
        if (slotID >= 0 && slotID < this.func_70302_i_() && this.getSlot(slotID) != null) {
            Slot slot = this.getSlot(slotID);
            if (slot.getItem() != null) {
                if (slot.getItem().field_77994_a <= slot.getMaxStackSize()) {
                    return slot.isValidForSlot(item);
                }
                return false;
            }
            return slot.isValidForSlot(item);
        }
        return true;
    }

    public Slot getSlot(int slotID) {
        return this.slots.get(slotID);
    }

    public int getLastSlotId() {
        return this.slots.size() - 1;
    }

    public List<Slot> getSlots() {
        return this.slots;
    }
}

