/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data;

import io.netty.buffer.ByteBuf;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemPattern {
    private int itemID;
    private int damage;
    private int count;
    private int progress;

    public ItemPattern() {
    }

    public ItemPattern(ItemStack itemStack) {
        this(itemStack, 0);
    }

    public ItemPattern(ItemStack itemStack, int progress) {
        this(Item.func_150891_b((Item)itemStack.func_77973_b()), itemStack.func_77960_j(), progress);
    }

    public ItemPattern(int itemID) {
        this(itemID, 0, 0);
    }

    public ItemPattern(int itemID, int damage) {
        this(itemID, damage, 0);
    }

    public ItemPattern(int itemID, int damage, int progress) {
        this.itemID = itemID;
        this.damage = damage;
        this.progress = progress;
    }

    public ItemPattern(NBTTagCompound tagCompound) {
        this.readFromNBT(tagCompound);
    }

    public ItemPattern(ByteBuf byteBuf) {
        this.readFromBuffer(byteBuf);
    }

    public ItemStack toItemStack(boolean withInfo) {
        ItemStack itemStack = new ItemStack(Item.func_150899_d((int)this.itemID));
        itemStack.func_77964_b(this.damage);
        if (withInfo) {
            itemStack.func_77982_d(new NBTTagCompound());
            itemStack.func_77978_p().func_74774_a("scan_progress", (byte)this.progress);
        }
        return itemStack;
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74777_a("id", (short)this.itemID);
        nbtTagCompound.func_74774_a("scan_progress", (byte)this.progress);
        nbtTagCompound.func_74777_a("Damage", (short)this.damage);
        nbtTagCompound.func_74774_a("Count", (byte)this.count);
    }

    public void writeToBuffer(ByteBuf byteBuf) {
        byteBuf.writeShort(this.itemID);
        byteBuf.writeByte(this.progress);
        byteBuf.writeShort(this.damage);
        byteBuf.writeByte(this.count);
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        this.itemID = nbtTagCompound.func_74765_d("id");
        this.progress = nbtTagCompound.func_74771_c("scan_progress");
        this.damage = nbtTagCompound.func_74765_d("Damage");
        this.count = nbtTagCompound.func_74771_c("Count");
    }

    public void readFromBuffer(ByteBuf byteBuf) {
        this.itemID = byteBuf.readShort();
        this.progress = byteBuf.readByte();
        this.damage = byteBuf.readShort();
        this.count = byteBuf.readByte();
    }

    public int getItemID() {
        return this.itemID;
    }

    public int getProgress() {
        return this.progress;
    }

    public float getProgressF() {
        return (float)this.progress / 100.0f;
    }

    public int getCount() {
        return this.count;
    }

    public int getDamage() {
        return this.damage;
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Item getItem() {
        return Item.func_150899_d((int)this.getItemID());
    }

    public boolean equals(ItemPattern pattern) {
        return this.getItemID() == pattern.getItemID() && this.getDamage() == pattern.getDamage();
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            return true;
        }
        if (object instanceof ItemPattern) {
            return this.equals((ItemPattern)object);
        }
        return false;
    }

    public String getDisplayName() {
        return this.toItemStack(false).func_82833_r();
    }

    public ItemPattern copy() {
        ItemPattern pattern = new ItemPattern(this.itemID, this.damage, this.progress);
        pattern.setCount(this.count);
        return pattern;
    }
}

