/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import matteroverdrive.api.events.bionicStats.MOEventBionicStat;
import matteroverdrive.client.sound.MOPositionedSound;
import matteroverdrive.data.biostats.AbstractBioticStat;
import matteroverdrive.entity.player.AndroidPlayer;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.util.IConfigSubscriber;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;

public class BioticStatNightVision
extends AbstractBioticStat
implements IConfigSubscriber {
    public static int ENERGY_PER_TICK = 16;

    public BioticStatNightVision(String name, int xp) {
        super(name, xp);
        this.setShowOnWheel(true);
        this.setShowOnHud(true);
    }

    @Override
    public String getDetails(int level) {
        return String.format(super.getDetails(level), EnumChatFormatting.YELLOW.toString() + ENERGY_PER_TICK + " RF");
    }

    @Override
    public void onAndroidUpdate(AndroidPlayer android, int level) {
        if (!android.getPlayer().field_70170_p.field_72995_K) {
            if (this.isActive(android, level)) {
                // empty if block
            }
        } else {
            this.manageNightvision(android, level);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void manageNightvision(AndroidPlayer android, int level) {
        if (this.isActive(android, level)) {
            android.getPlayer().func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 500));
        }
    }

    public void setActive(AndroidPlayer androidPlayer, int level, boolean active) {
        androidPlayer.getPlayer().func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 500));
        androidPlayer.getEffects().func_74757_a("Nightvision", active);
        androidPlayer.sync(EnumSet.of(AndroidPlayer.DataType.EFFECTS), true);
    }

    @Override
    public void onActionKeyPress(AndroidPlayer android, int level, boolean server) {
        if (this.equals(android.getActiveStat())) {
            if (server) {
                if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventBionicStat(this, level, android))) {
                    this.setActive(android, level, !android.getEffects().func_74767_n("Nightvision"));
                }
            } else if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventBionicStat(this, level, android))) {
                this.playSound(android);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void playSound(AndroidPlayer android) {
        if (!android.getEffects().func_74767_n("Nightvision")) {
            MOPositionedSound sound = new MOPositionedSound(new ResourceLocation("mo:night_vision"), 0.05f + android.getPlayer().func_70681_au().nextFloat() * 0.1f, 0.95f + android.getPlayer().func_70681_au().nextFloat() * 0.1f);
            sound.setAttenuationType(ISound.AttenuationType.NONE);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
        } else {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new MOPositionedSound(new ResourceLocation("mo:power_down"), 0.05f + android.getPlayer().func_70681_au().nextFloat() * 0.1f, 0.95f + android.getPlayer().func_70681_au().nextFloat() * 0.1f).setAttenuationType(ISound.AttenuationType.NONE));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onKeyPress(AndroidPlayer androidPlayer, int level, int keycode, boolean down) {
    }

    @Override
    public void onLivingEvent(AndroidPlayer androidPlayer, int level, LivingEvent event) {
    }

    @Override
    public void changeAndroidStats(AndroidPlayer androidPlayer, int level, boolean enabled) {
        if (!this.isEnabled(androidPlayer, level) && this.isActive(androidPlayer, level)) {
            this.setActive(androidPlayer, level, false);
        }
    }

    @Override
    public Multimap attributes(AndroidPlayer androidPlayer, int level) {
        return null;
    }

    @Override
    public boolean isActive(AndroidPlayer androidPlayer, int level) {
        return androidPlayer.getEffects().func_74767_n("Nightvision");
    }

    @Override
    public int getDelay(AndroidPlayer androidPlayer, int level) {
        return 0;
    }

    @Override
    public boolean isEnabled(AndroidPlayer androidPlayer, int level) {
        return super.isEnabled(androidPlayer, level) && androidPlayer.hasEnoughEnergyScaled(ENERGY_PER_TICK);
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        ENERGY_PER_TICK = config.getInt("nighvision_energy_per_tick", "abilities", 16, "The energy cost of the Nightvision");
    }
}

