/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.Random;
import java.util.UUID;
import matteroverdrive.api.events.bionicStats.MOEventBionicStat;
import matteroverdrive.client.sound.MOPositionedSound;
import matteroverdrive.data.biostats.AbstractBioticStat;
import matteroverdrive.entity.player.AndroidAttributes;
import matteroverdrive.entity.player.AndroidPlayer;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.IConfigSubscriber;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.lwjgl.input.Keyboard;

public class BioticStatShield
extends AbstractBioticStat
implements IConfigSubscriber {
    public static int ENERGY_PER_TICK = 64;
    public static int ENERGY_PER_DAMAGE = 256;
    public static int SHIELD_COOLDOWN = 320;
    public static int SHIELD_TIME = 160;
    public static final String TAG_SHIELD = "Shield";
    public static final String TAG_SHIELD_LAST_USE = "ShieldLastUse";
    public static final String TAG_HITS = "Hits";
    @SideOnly(value=Side.CLIENT)
    private MOPositionedSound shieldSound;
    private AttributeModifier modifyer;
    private Random random;

    public BioticStatShield(String name, int xp) {
        super(name, xp);
        this.setShowOnHud(true);
        this.modifyer = new AttributeModifier(UUID.fromString("ead117ad-105a-43fe-ab22-a31aee6adc42"), "Shield Slowdown", -0.4, 2);
        this.random = new Random();
        this.setShowOnWheel(true);
    }

    @Override
    public void onAndroidUpdate(AndroidPlayer android, int level) {
        if (!android.getPlayer().field_70170_p.field_72995_K) {
            if (android.getEffects().func_74767_n(TAG_SHIELD)) {
                android.extractEnergyScaled(ENERGY_PER_TICK);
            }
            if (android.getEffects().func_74764_b(TAG_HITS)) {
                NBTTagList attackList = android.getEffects().func_150295_c(TAG_HITS, 10);
                if (attackList.func_74745_c() > 0) {
                    if (attackList.func_150305_b(0).func_74762_e("time") > 0) {
                        attackList.func_150305_b(0).func_74768_a("time", attackList.func_150305_b(0).func_74762_e("time") - 1);
                    } else {
                        attackList.func_74744_a(0);
                    }
                } else {
                    android.getEffects().func_82580_o(TAG_HITS);
                }
                android.sync(EnumSet.of(AndroidPlayer.DataType.EFFECTS), true);
            }
        }
    }

    @Override
    public void onActionKeyPress(AndroidPlayer androidPlayer, int level, boolean server) {
        if (this.equals(androidPlayer.getActiveStat()) && this.canActivate(androidPlayer) && !MinecraftForge.EVENT_BUS.post((Event)new MOEventBionicStat(this, level, androidPlayer))) {
            this.setShield(androidPlayer, true);
            androidPlayer.sync(EnumSet.of(AndroidPlayer.DataType.EFFECTS), true);
        }
    }

    @Override
    public void onKeyPress(AndroidPlayer androidPlayer, int level, int keycode, boolean down) {
    }

    public void setShield(AndroidPlayer androidPlayer, boolean on) {
        androidPlayer.getEffects().func_74757_a(TAG_SHIELD, on);
        this.setLastShieldTime(androidPlayer, androidPlayer.getPlayer().field_70170_p.func_82737_E() + (long)SHIELD_COOLDOWN + (long)SHIELD_TIME);
        androidPlayer.sync(EnumSet.of(AndroidPlayer.DataType.EFFECTS), true);
        androidPlayer.getPlayer().field_70170_p.func_72956_a((Entity)androidPlayer.getPlayer(), "mo:shield_power_up", 0.6f + this.random.nextFloat() * 0.2f, 1.0f);
    }

    @Override
    public String getDetails(int level) {
        String key = "Unknown";
        try {
            key = Keyboard.getKeyName((int)ClientProxy.keyHandler.getBinding(1).func_151463_i());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.format(super.getDetails(level), key);
    }

    public boolean getShieldState(AndroidPlayer androidPlayer) {
        return androidPlayer.getEffects().func_74767_n(TAG_SHIELD);
    }

    public long getLastShieldTime(AndroidPlayer androidPlayer) {
        return androidPlayer.getEffects().func_74763_f("TAG_SHIELD_LAST_USE");
    }

    public void setLastShieldTime(AndroidPlayer androidPlayer, long time) {
        androidPlayer.getEffects().func_74772_a("TAG_SHIELD_LAST_USE", time);
    }

    public boolean canActivate(AndroidPlayer androidPlayer) {
        return this.getLastShieldTime(androidPlayer) - androidPlayer.getPlayer().field_70170_p.func_82737_E() <= 0L;
    }

    @Override
    public void onLivingEvent(AndroidPlayer androidPlayer, int level, LivingEvent event) {
        if (event instanceof LivingAttackEvent) {
            DamageSource source = ((LivingAttackEvent)event).source;
            if (this.getShieldState(androidPlayer)) {
                int energyReqired = MathHelper.func_76123_f((float)(((LivingAttackEvent)event).ammount * (float)ENERGY_PER_DAMAGE));
                if (this.isDamageValid(source) && event.isCancelable()) {
                    if (source.func_76364_f() != null) {
                        NBTTagCompound attack = new NBTTagCompound();
                        NBTTagList attackList = androidPlayer.getEffects().func_150295_c(TAG_HITS, 10);
                        attack.func_74780_a("x", source.func_76364_f().field_70165_t - event.entityLiving.field_70165_t);
                        attack.func_74780_a("y", source.func_76364_f().field_70163_u - (event.entityLiving.field_70163_u + 1.5));
                        attack.func_74780_a("z", source.func_76364_f().field_70161_v - event.entityLiving.field_70161_v);
                        attack.func_74768_a("time", 10);
                        attackList.func_74742_a((NBTBase)attack);
                        androidPlayer.getEffects().func_74782_a(TAG_HITS, (NBTBase)attackList);
                        androidPlayer.sync(EnumSet.of(AndroidPlayer.DataType.EFFECTS), true);
                        androidPlayer.getPlayer().field_70170_p.func_72956_a((Entity)androidPlayer.getPlayer(), "mo:shield_hit", 0.5f, 0.9f + this.random.nextFloat() * 0.2f);
                    }
                    if (androidPlayer.hasEnoughEnergyScaled(energyReqired)) {
                        androidPlayer.extractEnergyScaled(energyReqired);
                        event.setCanceled(true);
                    }
                }
            }
        } else if (event instanceof LivingHurtEvent) {
            DamageSource source = ((LivingHurtEvent)event).source;
            if (this.getShieldState(androidPlayer)) {
                int energyReqired = MathHelper.func_76123_f((float)(((LivingHurtEvent)event).ammount * (float)ENERGY_PER_DAMAGE));
                if (this.isDamageValid(source)) {
                    double energyMultiply = androidPlayer.getPlayer().func_110140_aT().func_111151_a(AndroidAttributes.attributeBatteryUse).func_111126_e();
                    energyReqired = (int)((double)energyReqired * energyMultiply);
                    int energyExtracted = androidPlayer.extractEnergy(energyReqired, true);
                    ((LivingHurtEvent)event).ammount *= (float)energyExtracted / (float)energyReqired;
                }
            }
        }
    }

    public boolean isDamageValid(DamageSource damageSource) {
        return damageSource.func_94541_c() || damageSource.func_76352_a();
    }

    @Override
    public void changeAndroidStats(AndroidPlayer androidPlayer, int level, boolean enabled) {
        if (androidPlayer.getPlayer().field_70170_p.field_72995_K) {
            if (!androidPlayer.getEffects().func_74767_n(TAG_SHIELD)) {
                this.stopShieldSound();
            } else {
                this.playShieldSound();
            }
        } else {
            long shieldTime = this.getLastShieldTime(androidPlayer) - androidPlayer.getPlayer().field_70170_p.func_82737_E();
            if (shieldTime < (long)SHIELD_COOLDOWN && androidPlayer.getEffects().func_74767_n(TAG_SHIELD)) {
                androidPlayer.getEffects().func_74757_a(TAG_SHIELD, false);
                androidPlayer.getEffects().func_82580_o(TAG_HITS);
                androidPlayer.sync(EnumSet.of(AndroidPlayer.DataType.EFFECTS), true);
                androidPlayer.getPlayer().field_70170_p.func_72956_a((Entity)androidPlayer.getPlayer(), "mo:shield_power_down", 0.6f + this.random.nextFloat() * 0.2f, 1.0f);
            }
        }
    }

    @Override
    public Multimap attributes(AndroidPlayer androidPlayer, int level) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    protected void playShieldSound() {
        if (this.shieldSound == null && !Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)this.shieldSound)) {
            this.shieldSound = new MOPositionedSound(new ResourceLocation("mo:shield_loop"), 0.3f + this.random.nextFloat() * 0.2f, 1.0f);
            this.shieldSound.setRepeat(true);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.shieldSound);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void stopShieldSound() {
        if (this.shieldSound != null && Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)this.shieldSound)) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)this.shieldSound);
            this.shieldSound = null;
        }
    }

    @Override
    public boolean isEnabled(AndroidPlayer androidPlayer, int level) {
        long shieldTime = this.getLastShieldTime(androidPlayer) - androidPlayer.getPlayer().field_70170_p.func_82737_E();
        return super.isEnabled(androidPlayer, level) && androidPlayer.hasEnoughEnergyScaled(ENERGY_PER_TICK) && (shieldTime <= 0L || shieldTime > (long)SHIELD_COOLDOWN);
    }

    @Override
    public boolean isActive(AndroidPlayer androidPlayer, int level) {
        return this.getShieldState(androidPlayer);
    }

    @Override
    public boolean showOnHud(AndroidPlayer android, int level) {
        return this.equals(android.getActiveStat()) || this.getShieldState(android);
    }

    @Override
    public int getDelay(AndroidPlayer androidPlayer, int level) {
        long shieldTime = this.getLastShieldTime(androidPlayer) - androidPlayer.getPlayer().field_70170_p.func_82737_E();
        if (shieldTime > 0L) {
            return (int)shieldTime;
        }
        return 0;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        ENERGY_PER_DAMAGE = config.getInt("shield_energy_per_damage", "abilities", 256, "The energy cost of each hit to the shield");
        ENERGY_PER_TICK = config.getInt("shield_energy_per_tick", "abilities", 64, "The energy cost of the shield per tick");
    }
}

