/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.EnumSet;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.events.bionicStats.MOEventBionicStat;
import matteroverdrive.data.biostats.AbstractBioticStat;
import matteroverdrive.entity.player.AndroidPlayer;
import matteroverdrive.network.packet.client.PacketSpawnParticle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;

public class BioticStatShockwave
extends AbstractBioticStat {
    public static final int DELAY = 240;

    public BioticStatShockwave(String name, int xp) {
        super(name, xp);
        this.showOnHud = true;
        this.showOnWheel = true;
    }

    @Override
    public String getDetails(int level) {
        return String.format(super.getDetails(level), EnumChatFormatting.YELLOW + Integer.toString(10) + EnumChatFormatting.GRAY);
    }

    @Override
    public void onAndroidUpdate(AndroidPlayer android, int level) {
        if (android.getActiveStat() != null && android.getActiveStat().equals(this) && !android.getPlayer().field_70122_E && android.getPlayer().field_70181_x < 0.0 && android.getPlayer().func_70093_af()) {
            Vec3 motion = Vec3.func_72443_a((double)android.getPlayer().field_70159_w, (double)android.getPlayer().field_70181_x, (double)android.getPlayer().field_70179_y).func_72444_a(Vec3.func_72443_a((double)0.0, (double)1.0, (double)0.0)).func_72432_b();
            android.getPlayer().func_70024_g(-motion.field_72450_a * 0.2, -motion.field_72448_b * 0.2, -motion.field_72449_c * 0.2);
        }
    }

    @Override
    public void onActionKeyPress(AndroidPlayer androidPlayer, int level, boolean server) {
        if (androidPlayer.getActiveStat() == this && server) {
            this.createShockwave(androidPlayer, (EntityLivingBase)androidPlayer.getPlayer(), 5.0f);
        }
    }

    @Override
    public void onKeyPress(AndroidPlayer androidPlayer, int level, int keycode, boolean down) {
    }

    @Override
    public void onLivingEvent(AndroidPlayer androidPlayer, int level, LivingEvent event) {
        if ((event instanceof LivingFallEvent || event instanceof PlayerFlyableFallEvent) && event.entityLiving.func_70093_af()) {
            if (event instanceof LivingFallEvent) {
                this.createShockwave(androidPlayer, event.entityLiving, ((LivingFallEvent)event).distance);
            } else if (event instanceof PlayerFlyableFallEvent) {
                this.createShockwave(androidPlayer, event.entityLiving, ((PlayerFlyableFallEvent)event).distance);
            }
        }
    }

    private void createShockwave(AndroidPlayer androidPlayer, EntityLivingBase entityPlayer, float distance) {
        if (this.getLastShockwaveTime(androidPlayer) < androidPlayer.getPlayer().field_70170_p.func_82737_E() && !MinecraftForge.EVENT_BUS.post((Event)new MOEventBionicStat(this, androidPlayer.getUnlockedLevel(this), androidPlayer)) && !entityPlayer.field_70170_p.field_72995_K) {
            float range = MathHelper.func_76131_a((float)distance, (float)5.0f, (float)10.0f);
            float power = MathHelper.func_76131_a((float)distance, (float)1.0f, (float)3.0f) * 0.8f;
            AxisAlignedBB area = AxisAlignedBB.func_72330_a((double)(entityPlayer.field_70165_t - (double)range), (double)(entityPlayer.field_70163_u - (double)range), (double)(entityPlayer.field_70161_v - (double)range), (double)(entityPlayer.field_70165_t + (double)range), (double)(entityPlayer.field_70163_u + (double)range), (double)(entityPlayer.field_70161_v + (double)range));
            List entities = entityPlayer.field_70170_p.func_72872_a(EntityLivingBase.class, area);
            for (EntityLivingBase entityLivingBase : entities) {
                if (entityLivingBase == entityPlayer) continue;
                Vec3 dir = Vec3.func_72443_a((double)entityPlayer.field_70165_t, (double)entityPlayer.field_70163_u, (double)entityPlayer.field_70161_v).func_72444_a(Vec3.func_72443_a((double)entityLivingBase.field_70165_t, (double)entityLivingBase.field_70163_u, (double)entityLivingBase.field_70161_v));
                double localDistance = dir.func_72433_c();
                double distanceMultiply = (double)range / Math.max(1.0, localDistance);
                dir = dir.func_72432_b();
                entityLivingBase.func_70024_g(dir.field_72450_a * (double)power * distanceMultiply, (double)(power * 0.2f), dir.field_72449_c * (double)power * distanceMultiply);
                entityLivingBase.field_70133_I = true;
                ShockwaveDamage damageSource = new ShockwaveDamage("android_shockwave", entityPlayer);
                entityLivingBase.func_70097_a((DamageSource)damageSource, power * 3.0f);
            }
            this.setLastShockwaveTime(androidPlayer, androidPlayer.getPlayer().field_70170_p.func_82737_E() + 240L);
            androidPlayer.sync(EnumSet.of(AndroidPlayer.DataType.EFFECTS));
            entityPlayer.field_70170_p.func_72956_a((Entity)entityPlayer, "mo:shockwave", 1.0f, 0.9f + entityPlayer.func_70681_au().nextFloat() * 0.1f);
            for (int i = 0; i < 20; ++i) {
                double d0 = entityPlayer.func_70681_au().nextGaussian() * 0.02;
                double d1 = entityPlayer.func_70681_au().nextGaussian() * 0.02;
                double d2 = entityPlayer.func_70681_au().nextGaussian() * 0.02;
                double d3 = 10.0;
                entityPlayer.field_70170_p.func_72869_a("explode", entityPlayer.field_70165_t + (double)(entityPlayer.func_70681_au().nextFloat() * entityPlayer.field_70130_N * 2.0f) - (double)entityPlayer.field_70130_N - d0 * d3, entityPlayer.field_70163_u + (double)(entityPlayer.func_70681_au().nextFloat() * entityPlayer.field_70131_O) - d1 * d3, entityPlayer.field_70161_v + (double)(entityPlayer.func_70681_au().nextFloat() * entityPlayer.field_70130_N * 2.0f) - (double)entityPlayer.field_70130_N - d2 * d3, d0, d1, d2);
            }
            MatterOverdrive.packetPipeline.sendToAllAround((IMessage)new PacketSpawnParticle("shockwave", androidPlayer.getPlayer().field_70165_t, androidPlayer.getPlayer().field_70163_u + (double)(androidPlayer.getPlayer().func_70047_e() / 2.0f), androidPlayer.getPlayer().field_70161_v, 1, 0, 10.0f), androidPlayer.getPlayer(), 64.0);
        }
    }

    @Override
    public void changeAndroidStats(AndroidPlayer androidPlayer, int level, boolean enabled) {
    }

    @Override
    public Multimap attributes(AndroidPlayer androidPlayer, int level) {
        return null;
    }

    @Override
    public boolean isActive(AndroidPlayer androidPlayer, int level) {
        return false;
    }

    @Override
    public boolean isEnabled(AndroidPlayer android, int level) {
        return super.isEnabled(android, level) && this.getDelay(android, level) <= 0;
    }

    @Override
    public int getDelay(AndroidPlayer androidPlayer, int level) {
        long shockwaveTime = this.getLastShockwaveTime(androidPlayer) - androidPlayer.getPlayer().field_70170_p.func_82737_E();
        if (shockwaveTime > 0L) {
            return (int)shockwaveTime;
        }
        return 0;
    }

    public long getLastShockwaveTime(AndroidPlayer androidPlayer) {
        return androidPlayer.getEffects().func_74763_f("SHOCK_LAST_USE");
    }

    public void setLastShockwaveTime(AndroidPlayer androidPlayer, long time) {
        androidPlayer.getEffects().func_74772_a("SHOCK_LAST_USE", time);
    }

    public class ShockwaveDamage
    extends DamageSource {
        EntityLivingBase source;

        public ShockwaveDamage(String p_i1566_1_, EntityLivingBase source) {
            super(p_i1566_1_);
            this.source = source;
            this.func_94540_d();
            this.func_76348_h();
        }

        public Entity func_76346_g() {
            return this.source;
        }
    }
}

