/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest;

import cpw.mods.fml.common.Loader;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class QuestItem {
    ItemStack itemStack;
    int itemAmount;
    int itemDamage;
    String name;
    String mod;
    NBTTagCompound nbtTagCompound;

    public QuestItem(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public QuestItem(String name, String mod) {
        this(name, mod, 1, 0, null);
    }

    public QuestItem(String name, String mod, int itemAmount) {
        this(name, mod, itemAmount, 0, null);
    }

    public QuestItem(String name, String mod, int itemAmount, int itemDamage) {
        this(name, mod, itemAmount, itemDamage, null);
    }

    public QuestItem(String name, String mod, int itemAmount, int itemDamage, NBTTagCompound tagCompound) {
        this.name = name;
        this.mod = mod;
        this.itemAmount = itemAmount;
        this.itemDamage = itemDamage;
        this.nbtTagCompound = tagCompound;
    }

    public boolean isModded() {
        return this.mod != null && !this.mod.isEmpty();
    }

    public boolean isModPresent() {
        return Loader.isModLoaded((String)this.mod);
    }

    public boolean canItemExist() {
        if (this.isModded()) {
            return this.isModPresent();
        }
        return true;
    }

    public ItemStack getItemStack() {
        if (this.isModded()) {
            Item item = (Item)Item.field_150901_e.func_82594_a(this.name);
            if (item != null) {
                ItemStack itemStack = new ItemStack(item, this.itemAmount, this.itemDamage);
                itemStack.func_77982_d(this.nbtTagCompound);
                return itemStack;
            }
        } else {
            return this.itemStack;
        }
        return null;
    }

    public static QuestItem fromItemStack(ItemStack itemStack) {
        return new QuestItem(itemStack);
    }
}

