/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.quest.QuestItem;
import matteroverdrive.data.quest.logic.QuestLogicRandomItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;

public class QuestLogicCollectItem
extends QuestLogicRandomItem {
    int dimensionID;
    boolean inSpecificDimension;
    boolean destroyOnCollect;
    int xpPerItem;
    int minItemCount;
    int maxItemCount;

    public QuestLogicCollectItem(QuestItem questItem, int minItemCount, int maxItemCount, int xpPerItem) {
        this.init(new QuestItem[]{questItem}, minItemCount, maxItemCount, xpPerItem);
    }

    public QuestLogicCollectItem(ItemStack itemStack, int minItemCount, int maxItemCount, int xpPerItem) {
        this.init(new QuestItem[]{QuestItem.fromItemStack(itemStack)}, minItemCount, maxItemCount, xpPerItem);
    }

    public QuestLogicCollectItem(Item item, int minItemCount, int maxItemCount, int xpPerItem) {
        this.init(new QuestItem[]{QuestItem.fromItemStack(new ItemStack(item))}, minItemCount, maxItemCount, xpPerItem);
    }

    protected void init(QuestItem[] questItems, int minItemCount, int maxItemCount, int xpPerItem) {
        super.init(questItems);
        this.minItemCount = minItemCount;
        this.maxItemCount = maxItemCount;
        this.xpPerItem = xpPerItem;
    }

    public QuestLogicCollectItem(ItemStack[] itemStacks, int minItemCount, int maxItemCount, int xpPerItem) {
        QuestItem[] questItems = new QuestItem[itemStacks.length];
        for (int i = 0; i < itemStacks.length; ++i) {
            questItems[i] = QuestItem.fromItemStack(itemStacks[i]);
        }
        this.init(questItems, minItemCount, maxItemCount, xpPerItem);
    }

    public QuestLogicCollectItem(Item[] items, int minItemCount, int maxItemCount, int xpPerItem) {
        QuestItem[] questItems = new QuestItem[items.length];
        for (int i = 0; i < items.length; ++i) {
            questItems[i] = QuestItem.fromItemStack(new ItemStack(items[i]));
        }
        this.init(questItems, minItemCount, maxItemCount, xpPerItem);
    }

    public QuestLogicCollectItem(QuestItem[] questItems, int minItemCount, int maxItemCount, int xpPerItem) {
        this.init(questItems, minItemCount, maxItemCount, xpPerItem);
    }

    @Override
    public String modifyInfo(QuestStack questStack, String info) {
        ItemStack itemStack = this.getItem(questStack);
        return String.format(info, "", this.getMaxItemCount(questStack), itemStack != null ? itemStack.func_82833_r() : "Unknown Item");
    }

    @Override
    public boolean isObjectiveCompleted(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.getItemCount(entityPlayer, questStack) >= this.getMaxItemCount(questStack);
    }

    @Override
    public String modifyObjective(QuestStack questStack, EntityPlayer entityPlayer, String objective, int objectiveIndex) {
        ItemStack itemStack = this.getItem(questStack);
        return String.format(objective, "", this.getItemCount(entityPlayer, questStack), this.getMaxItemCount(questStack), itemStack != null ? itemStack.func_82833_r() : "Unknown Item");
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack) {
        this.initTag(questStack);
        this.initItemType(random, questStack);
        this.getTag(questStack).func_74768_a("MaxItemCount", this.random(random, this.minItemCount, this.maxItemCount));
    }

    public int getItemCount(EntityPlayer entityPlayer, QuestStack questStack) {
        if (this.destroyOnCollect) {
            if (this.hasTag(questStack)) {
                return this.getTag(questStack).func_74762_e("ItemCount");
            }
            return 0;
        }
        int itemCount = 0;
        ItemStack itemStack = this.getItem(questStack);
        if (itemStack != null) {
            for (int i = 0; i < entityPlayer.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stackInSlot = entityPlayer.field_71071_by.func_70301_a(i);
                if (stackInSlot == null || !stackInSlot.func_77969_a(itemStack)) continue;
                itemCount += stackInSlot.field_77994_a;
            }
        }
        return itemCount;
    }

    public void setItemCount(QuestStack questStack, int count) {
        if (this.destroyOnCollect) {
            this.initTag(questStack);
            this.getTag(questStack).func_74768_a("ItemCount", count);
        }
    }

    public int getMaxItemCount(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            ItemStack itemStack = this.getItem(questStack);
            return itemStack.field_77994_a + this.getTag(questStack).func_74762_e("MaxItemCount");
        }
        return 0;
    }

    @Override
    public boolean onEvent(QuestStack questStack, Event event, EntityPlayer entityPlayer) {
        if (this.destroyOnCollect && event instanceof EntityItemPickupEvent && ((EntityItemPickupEvent)event).item.func_92059_d() != null) {
            if (this.inSpecificDimension && entityPlayer.field_70170_p.field_73011_w.field_76574_g != this.dimensionID) {
                return false;
            }
            ItemStack itemStack = ((EntityItemPickupEvent)event).item.func_92059_d();
            ItemStack questItem = this.getItem(questStack);
            if (itemStack != null && questItem != null && ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)questItem)) {
                this.initTag(questStack);
                int currentItemCount = this.getItemCount(entityPlayer, questStack);
                if (currentItemCount < this.getMaxItemCount(questStack)) {
                    this.setItemCount(questStack, ++currentItemCount);
                    if (this.isObjectiveCompleted(questStack, entityPlayer, 0) && this.autoComplete) {
                        questStack.markComplited(entityPlayer, false);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void onTaken(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void onCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
        if (!this.destroyOnCollect) {
            int itemCount = this.getMaxItemCount(questStack);
            ItemStack itemStack = this.getItem(questStack);
            if (itemStack != null) {
                for (int i = 0; i < entityPlayer.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stackInSlot = entityPlayer.field_71071_by.func_70301_a(i);
                    if (stackInSlot == null || !stackInSlot.func_77969_a(itemStack) || itemCount <= 0) continue;
                    int newItemCount = Math.max(0, itemCount - stackInSlot.field_77994_a);
                    int takenFromStack = itemCount - newItemCount;
                    entityPlayer.field_71071_by.func_70298_a(i, takenFromStack);
                    itemCount = newItemCount;
                }
            }
        }
    }

    @Override
    public void modifyRewards(QuestStack questStack, EntityPlayer entityPlayer, List<IQuestReward> rewards) {
    }

    @Override
    public int modifyXP(QuestStack questStack, EntityPlayer entityPlayer, int originalXp) {
        return originalXp + this.getMaxItemCount(questStack) * this.xpPerItem;
    }

    public QuestLogicCollectItem setDestroyOnCollect(boolean destroyOnCollect) {
        this.destroyOnCollect = destroyOnCollect;
        return this;
    }

    public QuestLogicCollectItem setDimensionID(int dimensionID) {
        this.inSpecificDimension = true;
        this.dimensionID = dimensionID;
        return this;
    }
}

