/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.BlockPos;
import matteroverdrive.data.quest.logic.QuestLogicBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import net.minecraftforge.event.world.BlockEvent;

public class QuestLogicPlaceBlock
extends QuestLogicBlock {
    private int radius;
    String namePattern;
    int minBlockPlace;
    int maxBlockPlace;

    public QuestLogicPlaceBlock(int radius, ItemStack blockStack) {
        this(radius, blockStack, 1, 1);
    }

    public QuestLogicPlaceBlock(int radius, ItemStack blockStack, int minBlockPlace, int maxBlockPlace) {
        super(blockStack);
        this.radius = radius;
        this.minBlockPlace = minBlockPlace;
        this.maxBlockPlace = maxBlockPlace;
    }

    public QuestLogicPlaceBlock(int radius, Block block) {
        this(radius, block, -1, 1, 1);
    }

    public QuestLogicPlaceBlock(int radius, Block block, int blockMetadata) {
        this(radius, block, blockMetadata, 1, 1);
    }

    public QuestLogicPlaceBlock(int radius, Block block, int blockMetadata, int minBlockPlace, int maxBlockPlace) {
        super(block, blockMetadata);
        this.radius = radius;
        this.minBlockPlace = minBlockPlace;
        this.maxBlockPlace = maxBlockPlace;
    }

    @Override
    public String modifyInfo(QuestStack questStack, String info) {
        return info;
    }

    @Override
    public boolean isObjectiveCompleted(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.getBlockPlaced(questStack) >= this.getMaxBlockPlace(questStack);
    }

    @Override
    public String modifyObjective(QuestStack questStack, EntityPlayer entityPlayer, String objective, int objectiveIndex) {
        objective = this.replaceBlockNameInText(objective);
        BlockPos pos = this.getPos(questStack);
        if (pos != null) {
            double distance = Vec3.func_72443_a((double)Math.floor(entityPlayer.field_70165_t), (double)Math.floor(entityPlayer.field_70163_u), (double)Math.floor(entityPlayer.field_70161_v)).func_72438_d(Vec3.func_72443_a((double)pos.x, (double)pos.y, (double)pos.z));
            objective = objective.replace("$distance", Integer.toString((int)Math.max(distance - (double)this.radius, 0.0)) + " blocks");
        } else {
            objective = objective.replace("$distance", "0 blocks");
        }
        return objective;
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack) {
        this.setMaxBlockPlace(questStack, this.random(random, this.minBlockPlace, this.maxBlockPlace));
    }

    @Override
    public boolean onEvent(QuestStack questStack, Event event, EntityPlayer entityPlayer) {
        if (event instanceof BlockEvent.PlaceEvent) {
            BlockEvent.PlaceEvent placeEvent = (BlockEvent.PlaceEvent)event;
            boolean isTheSameBlockFlag = false;
            boolean isNearTargetFlag = false;
            if (this.blockStack != null && placeEvent.itemInHand != null) {
                isTheSameBlockFlag = this.areBlockStackTheSame(placeEvent.itemInHand);
            } else if (this.areBlocksTheSame(placeEvent.block, placeEvent.blockMetadata)) {
                isTheSameBlockFlag = this.namePattern != null && placeEvent.itemInHand != null ? placeEvent.itemInHand.func_82833_r().matches(this.namePattern) : true;
            }
            BlockPos pos = this.getPos(questStack);
            if (pos != null && isTheSameBlockFlag && !(Vec3.func_72443_a((double)placeEvent.x, (double)placeEvent.y, (double)placeEvent.z).func_72438_d(Vec3.func_72443_a((double)pos.x, (double)pos.y, (double)pos.z)) <= (double)this.radius)) {
                return false;
            }
            if (isTheSameBlockFlag) {
                this.setBlockPlaced(questStack, this.getBlockPlaced(questStack) + 1);
                if (this.autoComplete) {
                    questStack.markComplited(entityPlayer, false);
                }
            }
            return isTheSameBlockFlag;
        }
        return false;
    }

    @Override
    public void onTaken(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void onCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void modifyRewards(QuestStack questStack, EntityPlayer entityPlayer, List<IQuestReward> rewards) {
    }

    protected void setBlockPlaced(QuestStack questStack, int placed) {
        this.initTag(questStack);
        this.getTag(questStack).func_74777_a("Placed", (short)placed);
    }

    protected int getBlockPlaced(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74765_d("Placed");
        }
        return 0;
    }

    protected void setMaxBlockPlace(QuestStack questStack, int maxBlockPlace) {
        this.initTag(questStack);
        this.getTag(questStack).func_74777_a("MaxPlaced", (short)maxBlockPlace);
    }

    protected int getMaxBlockPlace(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74765_d("MaxPlaced");
        }
        return 0;
    }

    protected BlockPos getPos(QuestStack questStack) {
        if (this.hasTag(questStack) && this.getTag(questStack).func_150297_b("Pos", 11)) {
            int[] pos = this.getTag(questStack).func_74759_k("Pos");
            return new BlockPos(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    public void setNamePattern(String namePattern) {
        this.namePattern = namePattern;
    }
}

