/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import java.util.ArrayList;
import java.util.Random;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.quest.QuestItem;
import matteroverdrive.data.quest.logic.AbstractQuestLogic;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public abstract class QuestLogicRandomItem
extends AbstractQuestLogic {
    QuestItem[] items;
    boolean randomItem;

    protected void init(QuestItem[] questItems) {
        this.items = questItems;
        this.randomItem = true;
    }

    protected void initItemType(Random random, QuestStack questStack) {
        if (this.randomItem) {
            ArrayList<Integer> avalibleBlocks = new ArrayList<Integer>();
            for (int i = 0; i < this.items.length; ++i) {
                ItemStack itemStack = this.items[i].getItemStack();
                if (itemStack == null) continue;
                avalibleBlocks.add(i);
            }
            if (avalibleBlocks.size() > 0) {
                this.setItemType(questStack, (Integer)avalibleBlocks.get(random.nextInt(avalibleBlocks.size())));
            }
        } else {
            for (int i = 0; i < this.items.length; ++i) {
                ItemStack itemStack = this.items[i].getItemStack();
                if (itemStack == null) continue;
                this.setItemType(questStack, i);
                return;
            }
        }
    }

    @Override
    public boolean canAccept(QuestStack questStack, EntityPlayer entityPlayer) {
        for (QuestItem item : this.items) {
            if (item.canItemExist()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(QuestStack questStack) {
        return this.items[this.getItemType(questStack)].getItemStack();
    }

    public int getItemType(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74771_c("ItemType");
        }
        return 0;
    }

    public void setItemType(QuestStack questStack, int itemType) {
        this.initTag(questStack);
        this.getTag(questStack).func_74774_a("ItemType", (byte)itemType);
    }

    public QuestLogicRandomItem setRandomItem(boolean randomItem) {
        this.randomItem = randomItem;
        return this;
    }
}

