/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.events.MOEventScan;
import matteroverdrive.api.inventory.IBlockScanner;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.quest.logic.QuestLogicBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovingObjectPosition;

public class QuestLogicScanBlock
extends QuestLogicBlock {
    private int minBlockScan;
    private int maxBlockScan;
    private int xpPerBlock;
    private boolean onlyDestoryable;

    public QuestLogicScanBlock(Block block, int blockMetadata, int minBlockScan, int maxBlockScan, int xpPerBlock) {
        super(block, blockMetadata);
        this.minBlockScan = minBlockScan;
        this.maxBlockScan = maxBlockScan;
        this.xpPerBlock = xpPerBlock;
    }

    @Override
    public String modifyInfo(QuestStack questStack, String info) {
        return this.replaceBlockNameInText(info);
    }

    @Override
    public boolean isObjectiveCompleted(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.getBlockScan(questStack) >= this.getMaxBlockScan(questStack);
    }

    @Override
    public String modifyObjective(QuestStack questStack, EntityPlayer entityPlayer, String objective, int objectiveIndex) {
        objective = this.replaceBlockNameInText(objective);
        objective = objective.replace("$scanAmount", Integer.toString(this.getBlockScan(questStack)));
        objective = objective.replace("$maxScanAmount", Integer.toString(this.getMaxBlockScan(questStack)));
        return objective;
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack) {
        this.setMaxBlockScan(questStack, this.random(random, this.minBlockScan, this.maxBlockScan));
    }

    @Override
    public boolean onEvent(QuestStack questStack, Event event, EntityPlayer entityPlayer) {
        if (event instanceof MOEventScan) {
            MOEventScan eventScan = (MOEventScan)event;
            if (eventScan.position.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                if (this.onlyDestoryable && eventScan.scannerStack.func_77973_b() instanceof IBlockScanner && !((IBlockScanner)eventScan.scannerStack.func_77973_b()).destroysBlocks(eventScan.scannerStack)) {
                    return false;
                }
                Block block = entityPlayer.field_70170_p.func_147439_a(eventScan.position.field_72311_b, eventScan.position.field_72312_c, eventScan.position.field_72309_d);
                int meta = entityPlayer.field_70170_p.func_72805_g(eventScan.position.field_72311_b, eventScan.position.field_72312_c, eventScan.position.field_72309_d);
                if (block != null && this.areBlocksTheSame(block, meta) && this.getBlockScan(questStack) < this.getMaxBlockScan(questStack)) {
                    this.setBlocScan(questStack, this.getBlockScan(questStack) + 1);
                    if (this.getBlockScan(questStack) >= this.getMaxBlockScan(questStack) && this.autoComplete) {
                        questStack.markComplited(entityPlayer, false);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int modifyXP(QuestStack questStack, EntityPlayer entityPlayer, int originalXp) {
        return originalXp + this.getMaxBlockScan(questStack) * this.xpPerBlock;
    }

    @Override
    public void onTaken(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void onCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void modifyRewards(QuestStack questStack, EntityPlayer entityPlayer, List<IQuestReward> rewards) {
    }

    protected void setMaxBlockScan(QuestStack questStack, int maxBlockScan) {
        this.initTag(questStack);
        this.getTag(questStack).func_74777_a("MaxBlockScan", (short)maxBlockScan);
    }

    protected int getMaxBlockScan(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74765_d("MaxBlockScan");
        }
        return 0;
    }

    protected int getBlockScan(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74765_d("BlockScan");
        }
        return 0;
    }

    protected void setBlocScan(QuestStack questStack, int blockScan) {
        this.initTag(questStack);
        this.getTag(questStack).func_74777_a("BlockScan", (short)blockScan);
    }

    public QuestLogicScanBlock setOnlyDestoryable(boolean onlyDestoryable) {
        this.onlyDestoryable = true;
        return this;
    }
}

