/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import cpw.mods.fml.common.eventhandler.Event;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.quest.logic.AbstractQuestLogic;
import matteroverdrive.util.MOLog;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class QuestLogicSpawnMobs
extends AbstractQuestLogic {
    private String customSpawnName;
    private Class<? extends Entity>[] mobClasses;
    private int minSpawnAmount;
    private int maxSpawnAmount;
    private int minSpawnRange;
    private int maxSpawnRange;

    public QuestLogicSpawnMobs(Class<? extends Entity>[] mobClasses, int minSpawnAmount, int maxSpawnAmount) {
        this.mobClasses = mobClasses;
        this.minSpawnAmount = minSpawnAmount;
        this.maxSpawnAmount = maxSpawnAmount;
    }

    public QuestLogicSpawnMobs(Class<? extends Entity> mobClass, int minSpawnAmount, int maxSpawnAmount) {
        this(new Class[]{mobClass}, minSpawnAmount, maxSpawnAmount);
    }

    @Override
    public String modifyInfo(QuestStack questStack, String info) {
        info = info.replace("$spawnType", this.getSpawnName(questStack));
        info = info.replace("$spawnAmount", Integer.toString(this.getSpawnAmount(questStack)));
        return info;
    }

    @Override
    public boolean isObjectiveCompleted(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return true;
    }

    @Override
    public String modifyObjective(QuestStack questStack, EntityPlayer entityPlayer, String objective, int objectiveIndex) {
        objective.replace("$spawnType", this.getSpawnName(questStack));
        objective = objective.replace("$spawnAmount", Integer.toString(this.getSpawnAmount(questStack)));
        return objective;
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack) {
        this.initTag(questStack);
        this.getTag(questStack).func_74774_a("SpawnType", (byte)random.nextInt(this.mobClasses.length));
        this.getTag(questStack).func_74777_a("SpawnAmount", (short)this.random(random, this.minSpawnAmount, this.maxSpawnAmount));
    }

    @Override
    public boolean onEvent(QuestStack questStack, Event event, EntityPlayer entityPlayer) {
        return false;
    }

    @Override
    public void onTaken(QuestStack questStack, EntityPlayer entityPlayer) {
        int spawnAmount = this.getSpawnAmount(questStack);
        for (int i = 0; i < spawnAmount; ++i) {
            try {
                Entity entity = this.mobClasses[this.getSpawnType(questStack)].getConstructor(World.class).newInstance(entityPlayer.field_70170_p);
                this.positionSpawn(entity, entityPlayer);
                if (entity instanceof EntityLiving) {
                    ((EntityLiving)entity).func_110161_a(null);
                    if (this.customSpawnName != null) {
                        ((EntityLiving)entity).func_94058_c(this.customSpawnName);
                    }
                }
                entityPlayer.field_70170_p.func_72838_d(entity);
                continue;
            }
            catch (InstantiationException e) {
                MOLog.error("Count not instantiate entity of type %s", this.mobClasses[this.getSpawnType(questStack)]);
                break;
            }
            catch (IllegalAccessException e) {
                MOLog.error("Count not call private constructor for entity of type %s", this.mobClasses[this.getSpawnType(questStack)]);
                break;
            }
            catch (InvocationTargetException e) {
                MOLog.error("Count not call constructor for entity of type %s", this.mobClasses[this.getSpawnType(questStack)]);
                break;
            }
            catch (NoSuchMethodException e) {
                MOLog.error("Count not find appropriate constructor for entity of type %s", this.mobClasses[this.getSpawnType(questStack)]);
                break;
            }
        }
    }

    private void positionSpawn(Entity spawn, EntityPlayer entityPlayer) {
        spawn.func_70107_b(entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v);
    }

    @Override
    public void onCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void modifyRewards(QuestStack questStack, EntityPlayer entityPlayer, List<IQuestReward> rewards) {
    }

    public String getSpawnName(QuestStack questStack) {
        return this.getEntityClassName(this.mobClasses[this.getSpawnType(questStack)], "Unknown Spawn");
    }

    public int getSpawnType(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return MathHelper.func_76125_a((int)this.getTag(questStack).func_74771_c("SpawnType"), (int)0, (int)this.mobClasses.length);
        }
        return 0;
    }

    public int getSpawnAmount(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74765_d("SpawnAmount");
        }
        return 0;
    }

    public void setCustomSpawnName(String customSpawnName) {
        this.customSpawnName = customSpawnName;
    }
}

