/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity.ai;

import matteroverdrive.api.entity.IRangedEnergyWeaponAttackMob;
import matteroverdrive.items.weapon.EnergyWeapon;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.Vec3;

public class EntityAIPhaserBoltAttack
extends EntityAIBase {
    private final EntityLiving entityHost;
    private final IRangedEnergyWeaponAttackMob rangedAttackEntityHost;
    private EntityLivingBase attackTarget;
    private Vec3 lastKnownShootLocation;
    private int rangedAttackDelayTime = -1;
    private double entityMoveSpeed;
    private int pathRetryTimer;
    private int shootPatienceTime;
    private int maxRangedAttackDelay;
    private float maxChaseDistance;
    private float maxChaseDistanceSq;
    private PathEntity lastChasePath;

    public EntityAIPhaserBoltAttack(IRangedEnergyWeaponAttackMob rangedAttackEntityHost, double entityMoveSpeed, int maxRangedAttackDelay, float maxChaseDistance) {
        this(rangedAttackEntityHost, entityMoveSpeed, maxRangedAttackDelay, maxRangedAttackDelay, maxChaseDistance);
    }

    public EntityAIPhaserBoltAttack(IRangedEnergyWeaponAttackMob rangedAttackEntityHost, double entityMoveSpeed, int p_i1650_4_, int maxRangedAttackDelay, float maxChaseDistance) {
        if (!(rangedAttackEntityHost instanceof EntityLivingBase)) {
            throw new IllegalArgumentException("EntityAIPhaserBoltAttack requires Mob implements IRangedEnergyWeaponAttackMob");
        }
        this.rangedAttackEntityHost = rangedAttackEntityHost;
        this.entityHost = (EntityLiving)rangedAttackEntityHost;
        this.entityMoveSpeed = entityMoveSpeed;
        this.maxRangedAttackDelay = maxRangedAttackDelay;
        this.maxChaseDistance = maxChaseDistance;
        this.maxChaseDistanceSq = maxChaseDistance * maxChaseDistance;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.entityHost.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.field_70128_L) {
            this.attackTarget = entitylivingbase;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.entityHost.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.attackTarget = null;
        this.pathRetryTimer = 0;
        this.rangedAttackDelayTime = -1;
        this.shootPatienceTime = 0;
    }

    public void func_75246_d() {
        double distanceToTargetSq = this.entityHost.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.field_70121_D.field_72338_b, this.attackTarget.field_70161_v);
        boolean canSee = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
        if (canSee) {
            this.lastKnownShootLocation = Vec3.func_72443_a((double)this.attackTarget.field_70169_q, (double)this.attackTarget.field_70167_r, (double)this.attackTarget.field_70166_s);
            this.shootPatienceTime = 60;
            ++this.pathRetryTimer;
        } else {
            this.pathRetryTimer = 0;
        }
        this.manageMovingToLastKnowMoveLocation(distanceToTargetSq);
        if (this.shootPatienceTime == 0) {
            this.lastKnownShootLocation = null;
        }
        if (this.lastKnownShootLocation != null) {
            this.manageShooting(canSee, distanceToTargetSq);
            --this.shootPatienceTime;
        } else {
            this.entityHost.func_70671_ap().func_75650_a(this.attackTarget.field_70165_t, this.attackTarget.field_70163_u + (double)this.attackTarget.func_70047_e(), this.attackTarget.field_70161_v, 30.0f, 30.0f);
        }
    }

    private void manageMovingToLastKnowMoveLocation(double distanceToTargetSq) {
        if (distanceToTargetSq <= (double)this.maxChaseDistanceSq && this.pathRetryTimer >= 20) {
            if (this.entityHost.func_70661_as().func_75505_d() != null && this.entityHost.func_70661_as().func_75505_d().equals(this.lastChasePath)) {
                this.entityHost.func_70661_as().func_75499_g();
            }
        } else if (this.entityHost.func_70661_as().func_75500_f()) {
            this.lastChasePath = this.entityHost.func_70661_as().func_75494_a((Entity)this.attackTarget);
            this.entityHost.func_70661_as().func_75484_a(this.lastChasePath, this.entityMoveSpeed);
        }
    }

    private void manageShooting(boolean canSeeTarget, double distanceToTargetSq) {
        this.entityHost.func_70671_ap().func_75650_a(this.lastKnownShootLocation.field_72450_a, this.lastKnownShootLocation.field_72448_b + (double)this.attackTarget.func_70047_e(), this.lastKnownShootLocation.field_72449_c, 30.0f, 30.0f);
        ItemStack weapon = this.rangedAttackEntityHost.getWeapon();
        if (this.rangedAttackDelayTime == 0 && weapon != null && weapon.func_77973_b() instanceof EnergyWeapon && ((EnergyWeapon)weapon.func_77973_b()).canFire(weapon, this.entityHost.field_70170_p, (EntityLivingBase)this.entityHost)) {
            if (distanceToTargetSq > (double)this.maxChaseDistanceSq) {
                return;
            }
            this.rangedAttackEntityHost.attackEntityWithRangedAttack(this.attackTarget, this.lastKnownShootLocation, canSeeTarget);
            this.rangedAttackDelayTime = this.maxRangedAttackDelay;
        } else if (this.rangedAttackDelayTime < 0) {
            this.rangedAttackDelayTime = this.maxRangedAttackDelay;
        } else if (this.rangedAttackDelayTime > 0) {
            --this.rangedAttackDelayTime;
        }
    }

    public void setMaxRangedAttackDelay(int time) {
        this.maxRangedAttackDelay = time;
    }

    public void setMaxChaseDistance(int maxChaseDistance) {
        this.maxChaseDistance = maxChaseDistance;
        this.maxChaseDistanceSq = maxChaseDistance * maxChaseDistance;
    }
}

