/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity.monster;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.entity.IRangedEnergyWeaponAttackMob;
import matteroverdrive.api.weapon.WeaponShot;
import matteroverdrive.entity.ai.AndroidTargetSelector;
import matteroverdrive.entity.ai.EntityAIMoveAlongPath;
import matteroverdrive.entity.ai.EntityAIPhaserBoltAttack;
import matteroverdrive.entity.ai.EntityAIRangedRunFromMelee;
import matteroverdrive.entity.monster.EntityRougeAndroidMob;
import matteroverdrive.init.MatterOverdriveItems;
import matteroverdrive.items.android.RougeAndroidParts;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.network.packet.bi.PacketFirePlasmaShot;
import matteroverdrive.util.AndroidPartsFactory;
import matteroverdrive.util.WeaponFactory;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityRangedRogueAndroidMob
extends EntityRougeAndroidMob
implements IRangedEnergyWeaponAttackMob {
    public static boolean UNLIMITED_WEAPON_ENERGY = true;
    private EntityAIPhaserBoltAttack aiBoltAttack = new EntityAIPhaserBoltAttack(this, 1.0, 60, 15.0f);
    private EntityAIRangedRunFromMelee aiRangedRunFromMelee = new EntityAIRangedRunFromMelee((EntityCreature)this, 1.0);

    public EntityRangedRogueAndroidMob(World world) {
        super(world);
        this.init(world);
    }

    public EntityRangedRogueAndroidMob(World world, int level, boolean legendary) {
        super(world, level, legendary);
        this.init(world);
    }

    protected void init(World world) {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiRangedRunFromMelee);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiBoltAttack);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveAlongPath(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, true, (IEntitySelector)new AndroidTargetSelector(this)));
        if (world != null && !world.field_72995_K) {
            this.setCombatTask();
        }
    }

    protected void func_82160_b(boolean recentlyHit, int lootingLevel) {
        int j;
        if (this.field_70718_bc > 0 && ((j = this.field_70146_Z.nextInt(400) - lootingLevel) < 5 || this.getIsLegendary())) {
            this.func_70099_a(this.func_71124_b(0).func_77946_l(), 0.0f);
        }
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70694_bm() != null) {
            // empty if block
        }
    }

    protected void func_70628_a(boolean recentlyHit, int lootingLevel) {
        if (!this.hasTeam() || recentlyHit) {
            int j = this.field_70146_Z.nextInt(2 + lootingLevel);
            for (int k = 0; k < j; ++k) {
                this.func_145779_a(MatterOverdriveItems.energyPack, 1);
            }
            float lootingModifier = (float)Math.min(lootingLevel, 10) / 10.0f;
            if (this.field_70146_Z.nextFloat() < 0.15f + lootingModifier || this.getIsLegendary()) {
                ItemStack part = MatterOverdrive.androidPartsFactory.generateRandomDecoratedPart(new AndroidPartsFactory.AndroidPartFactoryContext(this.getAndroidLevel(), (Entity)this, this.getIsLegendary()));
                if (part.func_77973_b() instanceof RougeAndroidParts) {
                    part.func_77982_d(new NBTTagCompound());
                    part.func_77978_p().func_74774_a("Type", (byte)1);
                }
                this.func_70099_a(part, 0.0f);
            }
        }
    }

    @Override
    public void func_82164_bB() {
        super.func_82164_bB();
        int androidLevel = this.getAndroidLevel();
        ItemStack gun = MatterOverdrive.weaponFactory.getRandomDecoratedEnergyWeapon(new WeaponFactory.WeaponGenerationContext(androidLevel, (Entity)this, this.getIsLegendary()));
        this.func_70062_b(0, gun);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)(((EnergyWeapon)gun.func_77973_b()).getRange(gun) - 2));
    }

    public void setCombatTask() {
        ItemStack itemstack = this.func_70694_bm();
        if (itemstack != null && itemstack.func_77973_b() instanceof EnergyWeapon) {
            this.aiBoltAttack.setMaxChaseDistance(((EnergyWeapon)itemstack.func_77973_b()).getRange(itemstack) - 2);
            if (itemstack.func_77973_b() == MatterOverdriveItems.ionSniper) {
                this.aiRangedRunFromMelee.setMinDistance(16.0);
            } else if (itemstack.func_77973_b() != MatterOverdriveItems.plasmaShotgun) {
                this.aiRangedRunFromMelee.setMinDistance(3.0);
            }
        }
    }

    public IEntityLivingData func_110161_a(IEntityLivingData entityLivingData) {
        entityLivingData = super.func_110161_a(entityLivingData);
        this.func_82164_bB();
        this.func_82162_bC();
        return entityLivingData;
    }

    @Override
    public void attackEntityWithRangedAttack(EntityLivingBase target, Vec3 lastSeenPosition, boolean canSee) {
        ItemStack weapon = this.func_70694_bm();
        if (!this.field_70170_p.field_72995_K) {
            if (lastSeenPosition == null) {
                lastSeenPosition = Vec3.func_72443_a((double)target.field_70165_t, (double)target.field_70163_u, (double)target.field_70161_v);
            }
            if (weapon.func_77973_b() instanceof EnergyWeapon) {
                EnergyWeapon energyWeapon = (EnergyWeapon)weapon.func_77973_b();
                Vec3 pos = Vec3.func_72443_a((double)this.field_70165_t, (double)(this.field_70163_u + (double)this.func_70047_e()), (double)this.field_70161_v);
                Vec3 dir = Vec3.func_72443_a((double)(lastSeenPosition.field_72450_a - this.field_70165_t), (double)(lastSeenPosition.field_72448_b - this.field_70163_u), (double)(lastSeenPosition.field_72449_c - this.field_70161_v));
                WeaponShot shot = energyWeapon.createShot(weapon, (EntityLivingBase)this, true);
                float difficulty = MathHelper.func_76131_a((float)(0.2f * (float)this.field_70170_p.field_73013_u.func_151525_a()), (float)0.0f, (float)0.6f) + (float)this.getAndroidLevel() * 0.13333334f + (this.getIsLegendary() ? 0.3f : 0.0f);
                shot.setDamage(shot.getDamage() * difficulty);
                difficulty = (float)(3 - this.field_70170_p.field_73013_u.func_151525_a()) * 4.0f;
                shot.setAccuracy(shot.getAccuracy() + difficulty);
                energyWeapon.onServerFire(weapon, (EntityLivingBase)this, shot, pos, dir, 0);
                energyWeapon.setHeat(weapon, 0.0f);
                if (UNLIMITED_WEAPON_ENERGY) {
                    energyWeapon.rechargeFully(weapon);
                }
                MatterOverdrive.packetPipeline.sendToAllAround(new PacketFirePlasmaShot(this.func_145782_y(), pos, dir, shot), this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
                difficulty = 1.0f + (float)(3 - this.field_70170_p.field_73013_u.func_151525_a()) * 0.5f;
                this.aiBoltAttack.setMaxRangedAttackDelay((int)((float)((EnergyWeapon)weapon.func_77973_b()).getShootCooldown(weapon) * difficulty));
            }
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.setCombatTask();
    }

    public void func_70062_b(int slot, ItemStack itemStack) {
        super.func_70062_b(slot, itemStack);
        if (!this.field_70170_p.field_72995_K && slot == 0) {
            this.setCombatTask();
        }
    }

    @Override
    public ItemStack getWeapon() {
        return this.func_70694_bm();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        double d1 = this.field_70121_D.func_72320_b();
        d1 *= 64.0 * this.field_70155_l;
        return p_70112_1_ < (d1 += this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e()) * d1;
    }
}

