/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity.monster;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.entity.monster.EntityRangedRogueAndroidMob;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.util.IConfigSubscriber;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.Property;

public class EntityRogueAndroid
implements IConfigSubscriber {
    public static int MAX_ANDROIDS_PER_CHUNK = 4;
    private static HashSet<String> biomesBlacklist = new HashSet();
    private static HashSet<String> biomesWhitelist = new HashSet();
    public static HashSet<Integer> dimensionBlacklist = new HashSet();
    public static HashSet<Integer> dimensionWhitelist = new HashSet();
    private static List<BiomeGenBase.SpawnListEntry> spawnListEntries = new ArrayList<BiomeGenBase.SpawnListEntry>();

    public static void addAsBiomeGen(Class<? extends EntityLiving> entityClass) {
        spawnListEntries.add(new BiomeGenBase.SpawnListEntry(entityClass, 15, 1, 2));
        EntityRogueAndroid.addInBiome(BiomeGenBase.func_150565_n());
    }

    private static void addInBiome(BiomeGenBase[] biomes) {
        EntityRogueAndroid.loadBiomeBlacklist(MatterOverdrive.configHandler);
        EntityRogueAndroid.loadBiomesWhitelist(MatterOverdrive.configHandler);
        for (int i = 0; i < biomes.length; ++i) {
            if (biomes[i] == null) continue;
            List spawnList = biomes[i].func_76747_a(EnumCreatureType.monster);
            for (BiomeGenBase.SpawnListEntry entry : spawnListEntries) {
                if (!EntityRogueAndroid.isBiomeValid(biomes[i]) || spawnList.contains(entry) || entry.field_76292_a <= 0) continue;
                spawnList.add(entry);
            }
        }
    }

    private static boolean isBiomeValid(BiomeGenBase biome) {
        if (biome != null) {
            if (biomesWhitelist.size() > 0) {
                return biomesWhitelist.contains(biome);
            }
            return !biomesBlacklist.contains(biome.field_76791_y.toLowerCase());
        }
        return false;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        for (BiomeGenBase.SpawnListEntry entry : spawnListEntries) {
            entry.field_76292_a = config.config.getInt("spawn_chance", "entities.rogue_android", 15, 0, 100, "The spawn change of the Rogue Android");
        }
        EntityRogueAndroid.loadDimensionBlacklist(config);
        EntityRogueAndroid.loadDimesionWhitelist(config);
        EntityRogueAndroid.loadBiomeBlacklist(config);
        EntityRogueAndroid.loadBiomesWhitelist(config);
        EntityRangedRogueAndroidMob.UNLIMITED_WEAPON_ENERGY = config.getBool("unlimited_weapon_energy", "entities.rogue_android", true, "Do Ranged Rogue Androids have unlimited weapon energy in their weapons");
        MAX_ANDROIDS_PER_CHUNK = config.getInt("max_android_per_chunk", "entities.rogue_android", 4, "The max amount of Rogue Android that can spawn in a given chunk");
    }

    private static void loadBiomeBlacklist(ConfigurationHandler config) {
        biomesBlacklist.clear();
        String[] blacklist = config.config.getStringList("biome.blacklist", "entities.rogue_android", new String[]{"Hell", "Sky", "MushroomIsland", "MushroomIslandShore"}, "Rogue Android biome blacklist");
        for (int i = 0; i < blacklist.length; ++i) {
            biomesBlacklist.add(blacklist[i].toLowerCase());
        }
    }

    private static void loadBiomesWhitelist(ConfigurationHandler configurationHandler) {
        biomesWhitelist.clear();
        String[] whitelist = configurationHandler.config.getStringList("biome.whitelist", "entities.rogue_android", new String[0], "Rogue Android biome whitelist");
        for (int i = 0; i < whitelist.length; ++i) {
            biomesBlacklist.add(whitelist[i].toLowerCase());
        }
    }

    private static void loadDimensionBlacklist(ConfigurationHandler configurationHandler) {
        dimensionBlacklist.clear();
        Property blacklistProp = configurationHandler.config.get("entities.rogue_android", "dimension.blacklist", new int[]{1});
        blacklistProp.comment = "Rogue Android Dimension ID blacklist";
        int[] blacklist = blacklistProp.getIntList();
        for (int i = 0; i < blacklist.length; ++i) {
            dimensionBlacklist.add(blacklist[i]);
        }
    }

    private static void loadDimesionWhitelist(ConfigurationHandler configurationHandler) {
        int[] whitelist;
        dimensionWhitelist.clear();
        Property whitelistProp = configurationHandler.config.get("entities.rogue_android", "dimension.whitelist", new int[0]);
        whitelistProp.comment = "Rogue Android Dimension ID whitelist";
        for (int item : whitelist = whitelistProp.getIntList()) {
            dimensionWhitelist.add(item);
        }
    }
}

