/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity.weapon;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import matteroverdrive.api.events.weapon.MOEventPlasmaBlotHit;
import matteroverdrive.api.gravity.IGravitationalAnomaly;
import matteroverdrive.api.gravity.IGravityEntity;
import matteroverdrive.api.weapon.WeaponShot;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.sound.MOPositionedSound;
import matteroverdrive.fx.PhaserBoltRecoil;
import matteroverdrive.items.weapon.EnergyWeapon;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.particle.EntityExplodeFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class PlasmaBolt
extends Entity
implements IProjectile,
IGravityEntity,
IEntityAdditionalSpawnData {
    private int blockX = -1;
    private int blockY = -1;
    private int blockZ = -1;
    private int distanceTraveled;
    private float damage;
    public Entity shootingEntity;
    private Block block;
    private int life;
    private int color;
    private float fireDamageMultiply;
    private ItemStack weapon;
    private float renderSize = 2.0f;
    private float knockback;

    public PlasmaBolt(World world) {
        super(world);
        this.field_70155_l = 10.0;
        this.func_70105_a(0.5f, 0.5f);
    }

    public PlasmaBolt(World world, EntityLivingBase entityLivingBase, Vec3 position, Vec3 dir, WeaponShot shot, float speed) {
        super(world);
        this.field_70146_Z.setSeed(shot.getSeed());
        this.func_145769_d(this.field_70146_Z.nextInt(Integer.MAX_VALUE));
        this.field_70155_l = 10.0;
        this.shootingEntity = entityLivingBase;
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(position.field_72450_a, position.field_72448_b, position.field_72449_c, entityLivingBase.field_70177_z, entityLivingBase.field_70125_A);
        this.field_70159_w = dir.field_72450_a;
        this.field_70181_x = dir.field_72448_b;
        this.field_70179_y = dir.field_72449_c;
        this.field_70129_M = 0.0f;
        this.life = shot.getRange();
        this.damage = shot.getDamage();
        this.color = shot.getColor();
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, speed * 1.5f, shot.getAccuracy());
    }

    public void func_70186_c(double x, double y, double z, float speed, float accuracy) {
        float dirLength = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)dirLength;
        y /= (double)dirLength;
        z /= (double)dirLength;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)accuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)accuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)accuracy;
        this.field_70159_w = x *= (double)speed;
        this.field_70181_x = y *= (double)speed;
        this.field_70179_y = z *= (double)speed;
        float f3 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f3) * 180.0 / Math.PI);
    }

    protected void func_70088_a() {
    }

    public void simulateDelay(int delay) {
        if (delay > 0) {
            double lastMotionX = this.field_70159_w;
            double lastMotionY = this.field_70181_x;
            double lastMotionZ = this.field_70179_y;
            this.field_70159_w *= (double)delay;
            this.field_70181_x *= (double)delay;
            this.field_70179_y *= (double)delay;
            this.func_70071_h_();
            this.field_70159_w = lastMotionX;
            this.field_70181_x = lastMotionY;
            this.field_70179_y = lastMotionZ;
        }
    }

    public void func_70071_h_() {
        Block block;
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        }
        if ((block = this.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ)).func_149688_o() != Material.field_151579_a) {
            block.func_149719_a((IBlockAccess)this.field_70170_p, this.blockX, this.blockY, this.blockZ);
            AxisAlignedBB axisalignedbb = block.func_149668_a(this.field_70170_p, this.blockX, this.blockY, this.blockZ);
            if (axisalignedbb != null && axisalignedbb.func_72318_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v))) {
                this.func_70106_y();
            }
        }
        if (this.distanceTraveled > this.life) {
            this.func_70106_y();
            return;
        }
        this.distanceTraveled = (int)((double)this.distanceTraveled + Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y).func_72433_c());
        float motionLeway = 0.0f;
        Vec3 vec31 = Vec3.func_72443_a((double)(this.field_70165_t - this.field_70159_w * (double)motionLeway), (double)(this.field_70163_u - this.field_70181_x * (double)motionLeway), (double)(this.field_70161_v - this.field_70179_y * (double)motionLeway));
        Vec3 vec3 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        MovingObjectPosition movingobjectposition = this.field_70170_p.func_147447_a(vec31, vec3, false, true, false);
        vec31 = Vec3.func_72443_a((double)(this.field_70165_t - this.field_70159_w * (double)motionLeway), (double)(this.field_70163_u - this.field_70181_x * (double)motionLeway), (double)(this.field_70161_v - this.field_70179_y * (double)motionLeway));
        vec3 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        if (movingobjectposition != null) {
            vec3 = Vec3.func_72443_a((double)movingobjectposition.field_72307_f.field_72450_a, (double)movingobjectposition.field_72307_f.field_72448_b, (double)movingobjectposition.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        Vec3 hit = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            float f1;
            AxisAlignedBB axisalignedbb1;
            MovingObjectPosition movingobjectposition1;
            Entity entity1 = (Entity)list.get(i);
            if (entity1 == null || !entity1.func_70067_L() || entity1.field_70128_L || !(entity1 instanceof EntityLivingBase) || ((EntityLivingBase)entity1).field_70725_aQ != 0 || this.shootingEntity != null && (this.shootingEntity instanceof EntityLivingBase && !this.canAttackTeammate((EntityLivingBase)entity1, (EntityLivingBase)this.shootingEntity) || entity1 == this.shootingEntity || entity1 == this.shootingEntity.field_70154_o) || (movingobjectposition1 = (axisalignedbb1 = entity1.field_70121_D.func_72314_b((double)(f1 = 0.4f), (double)f1, (double)f1)).func_72327_a(vec31, vec3)) == null || !((d1 = vec31.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            hit = movingobjectposition1.field_72307_f;
            d0 = d1;
        }
        if (entity != null && entity != this.shootingEntity) {
            movingobjectposition = new MovingObjectPosition(entity, hit);
        }
        if (movingobjectposition != null && movingobjectposition.field_72308_g != null && movingobjectposition.field_72308_g instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)movingobjectposition.field_72308_g;
            if (entityplayer.field_71075_bZ.field_75102_a || this.shootingEntity instanceof EntityPlayer && !((EntityPlayer)this.shootingEntity).func_96122_a(entityplayer)) {
                movingobjectposition = null;
            }
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.field_72308_g != null) {
                DamageSource damagesource = this.shootingEntity == null ? this.getDamageSource(this) : this.getDamageSource(this.shootingEntity);
                movingobjectposition.field_72308_g.field_70172_ad = 0;
                double lastMotionX = movingobjectposition.field_72308_g.field_70159_w;
                double lastMotionY = movingobjectposition.field_72308_g.field_70181_x;
                double lastMotionZ = movingobjectposition.field_72308_g.field_70179_y;
                if (movingobjectposition.field_72308_g.func_70097_a(damagesource, this.damage)) {
                    movingobjectposition.field_72308_g.field_70159_w = lastMotionX + (movingobjectposition.field_72308_g.field_70159_w - lastMotionX) * (double)this.knockback;
                    movingobjectposition.field_72308_g.field_70181_x = lastMotionY + (movingobjectposition.field_72308_g.field_70181_x - lastMotionY) * (double)this.knockback;
                    movingobjectposition.field_72308_g.field_70179_y = lastMotionZ + (movingobjectposition.field_72308_g.field_70179_y - lastMotionZ) * (double)this.knockback;
                    if (movingobjectposition.field_72308_g instanceof EntityLivingBase) {
                        EntityLivingBase entitylivingbase = (EntityLivingBase)movingobjectposition.field_72308_g;
                        if (this.shootingEntity != null && this.shootingEntity instanceof EntityLivingBase) {
                            EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)this.shootingEntity);
                            EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.shootingEntity), (Entity)entitylivingbase);
                        }
                        if (this.shootingEntity != null && movingobjectposition.field_72308_g != this.shootingEntity && movingobjectposition.field_72308_g instanceof EntityPlayer && this.shootingEntity instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)this.shootingEntity).field_71135_a.func_147359_a((Packet)new S2BPacketChangeGameState(6, 0.0f));
                        }
                    }
                    if (this.fireDamageMultiply > 0.0f) {
                        movingobjectposition.field_72308_g.func_70015_d((int)(10.0f * this.fireDamageMultiply));
                    }
                    if (!(movingobjectposition.field_72308_g instanceof EntityEnderman)) {
                        this.func_70106_y();
                    }
                } else if (movingobjectposition.field_72308_g instanceof EntityLivingBase) {
                    this.func_70106_y();
                }
                if (this.weapon != null && this.weapon.func_77973_b() instanceof EnergyWeapon) {
                    if (this.field_70170_p.field_72995_K) {
                        ((EnergyWeapon)this.weapon.func_77973_b()).onProjectileHit(movingobjectposition, this.weapon, this.field_70170_p, 5.0f);
                        this.onHit(movingobjectposition);
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new MOEventPlasmaBlotHit(this.weapon, movingobjectposition, this, this.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER));
                }
            } else {
                this.blockX = movingobjectposition.field_72311_b;
                this.blockY = movingobjectposition.field_72312_c;
                this.blockZ = movingobjectposition.field_72309_d;
                this.block = this.field_70170_p.func_147439_a(this.blockX, this.blockY, this.blockZ);
                if (this.block.func_149688_o() != Material.field_151579_a) {
                    this.block.func_149670_a(this.field_70170_p, this.blockX, this.blockY, this.blockZ, (Entity)this);
                    if (this.block instanceof BlockTNT) {
                        this.field_70170_p.func_147468_f(this.blockX, this.blockY, this.blockZ);
                        EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(this.field_70170_p, (double)((float)this.blockX + 0.5f), (double)((float)this.blockY + 0.5f), (double)((float)this.blockZ + 0.5f), this.shootingEntity instanceof EntityLivingBase ? (EntityLivingBase)this.shootingEntity : null);
                        entitytntprimed.field_70516_a = 0;
                        this.field_70170_p.func_72838_d((Entity)entitytntprimed);
                    }
                }
                if (this.weapon != null && this.weapon.func_77973_b() instanceof EnergyWeapon) {
                    if (this.field_70170_p.field_72995_K) {
                        ((EnergyWeapon)this.weapon.func_77973_b()).onProjectileHit(movingobjectposition, this.weapon, this.field_70170_p, 5.0f);
                        this.onHit(movingobjectposition);
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new MOEventPlasmaBlotHit(this.weapon, movingobjectposition, this, this.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER));
                }
                this.func_70106_y();
            }
        }
        this.field_70121_D.func_72317_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70165_t = (this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d) / 2.0;
        this.field_70163_u = this.field_70121_D.field_72338_b + (double)this.field_70129_M - (double)this.field_70139_V;
        this.field_70161_v = (this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f) / 2.0;
        this.func_145775_I();
    }

    @SideOnly(value=Side.CLIENT)
    protected void onHit(MovingObjectPosition hit) {
        Vec3 sideHit = hit.field_72313_a.equals((Object)MovingObjectPosition.MovingObjectType.BLOCK) ? Vec3.func_72443_a((double)ForgeDirection.getOrientation((int)hit.field_72310_e).offsetX, (double)ForgeDirection.getOrientation((int)hit.field_72310_e).offsetY, (double)ForgeDirection.getOrientation((int)hit.field_72310_e).offsetZ) : Vec3.func_72443_a((double)(-this.field_70159_w), (double)(-this.field_70181_x), (double)(-this.field_70179_y));
        Color c = new Color(this.color);
        EntityExplodeFX explodeFX = new EntityExplodeFX(this.field_70170_p, hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, 0.0, 0.0, 0.0);
        explodeFX.func_70538_b(c.getFloatR(), c.getFloatG(), c.getFloatB());
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)explodeFX);
        if (this.field_70146_Z.nextFloat() < 0.8f) {
            int hitPraticles = Math.max(0, (int)(16.0f * this.renderSize) - (int)(8.0f * this.renderSize) * Minecraft.func_71410_x().field_71474_y.field_74362_aa);
            for (int i = 0; i < hitPraticles; ++i) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new PhaserBoltRecoil(this.field_70170_p, hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, c, sideHit.field_72450_a * 30.0, sideHit.field_72448_b * 30.0, sideHit.field_72449_c * 30.0));
            }
            if ((double)this.getRenderSize() > 0.5) {
                MOPositionedSound sizzleSound = new MOPositionedSound(new ResourceLocation("mo:sizzle"), this.field_70146_Z.nextFloat() * 0.2f + 0.4f, this.field_70146_Z.nextFloat() * 0.6f + 0.7f);
                sizzleSound.setPosition((float)hit.field_72307_f.field_72450_a, (float)hit.field_72307_f.field_72448_b, (float)hit.field_72307_f.field_72449_c);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sizzleSound);
                if (hit.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                    MOPositionedSound ricochetSound = new MOPositionedSound(new ResourceLocation("mo:laser_ricochet"), this.field_70146_Z.nextFloat() * 0.2f + 0.6f, this.field_70146_Z.nextFloat() * 0.2f + 1.0f);
                    ricochetSound.setPosition((float)hit.field_72307_f.field_72450_a, (float)hit.field_72307_f.field_72448_b, (float)hit.field_72307_f.field_72449_c);
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)ricochetSound);
                }
            }
        }
        if (hit.field_72313_a.equals((Object)MovingObjectPosition.MovingObjectType.ENTITY) && hit.field_72308_g instanceof EntityLivingBase) {
            for (int s = 0; s < Math.max(0, 10 - 5 * Minecraft.func_71410_x().field_71474_y.field_74362_aa); ++s) {
                this.field_70170_p.func_72869_a("reddust", hit.field_72307_f.field_72450_a + this.field_70146_Z.nextDouble() * 0.4 - 0.2, hit.field_72307_f.field_72448_b + this.field_70146_Z.nextDouble() * 0.4 - 0.2, hit.field_72307_f.field_72449_c + this.field_70146_Z.nextDouble() * 0.4 - 0.2, 0.0, 0.0, 0.0);
            }
        }
    }

    private boolean canAttackTeammate(EntityLivingBase shooter, EntityLivingBase target) {
        if (shooter != null && target != null) {
            if (shooter.func_96124_cp() != null && shooter.func_142014_c(target)) {
                return shooter.func_96124_cp().func_96665_g();
            }
            return true;
        }
        return true;
    }

    public DamageSource getDamageSource(Entity shootingEntity) {
        EntityDamageSourceIndirect dmg = new EntityDamageSourceIndirect("plasmaBolt", (Entity)this, shootingEntity);
        dmg.func_76349_b();
        return dmg;
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74777_a("xTile", (short)this.blockX);
        tagCompound.func_74777_a("yTile", (short)this.blockY);
        tagCompound.func_74777_a("zTile", (short)this.blockZ);
        tagCompound.func_74776_a("damage", this.damage);
        tagCompound.func_74768_a("distanceTraveled", this.distanceTraveled);
        tagCompound.func_74768_a("life", this.life);
        tagCompound.func_74768_a("color", this.color);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        this.blockX = tagCompound.func_74765_d("xTile");
        this.blockY = tagCompound.func_74765_d("yTile");
        this.blockZ = tagCompound.func_74765_d("zTile");
        if (tagCompound.func_150297_b("damage", 99)) {
            this.damage = tagCompound.func_74760_g("damage");
        }
        if (tagCompound.func_150297_b("ticksInAir", 99)) {
            this.distanceTraveled = tagCompound.func_74762_e("distanceTraveled");
        }
        if (tagCompound.func_150297_b("life", 99)) {
            this.life = tagCompound.func_74762_e("life");
        }
        if (tagCompound.func_150297_b("color", 99)) {
            this.color = tagCompound.func_74762_e("color");
        }
    }

    public void func_70100_b_(EntityPlayer p_70100_1_) {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public void setDamage(float p_70239_1_) {
        this.damage = p_70239_1_;
    }

    public double getDamage() {
        return this.damage;
    }

    public boolean func_70075_an() {
        return false;
    }

    public void setWeapon(ItemStack weapon) {
        this.weapon = weapon;
    }

    public int getColor() {
        return this.color;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    public boolean isAffectedByAnomaly(IGravitationalAnomaly anomaly) {
        return false;
    }

    @Override
    public void onEntityConsumed(IGravitationalAnomaly anomaly) {
    }

    public void setFireDamageMultiply(float fiery) {
        this.fireDamageMultiply = fiery;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeFloat(this.damage);
        buffer.writeInt(this.color);
        buffer.writeFloat(this.fireDamageMultiply);
        buffer.writeInt(this.life);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.damage = additionalData.readFloat();
        this.color = additionalData.readInt();
        this.fireDamageMultiply = additionalData.readFloat();
        this.life = additionalData.readInt();
    }

    public float getLife() {
        return 1.0f - (float)this.distanceTraveled / (float)this.life;
    }

    public float setLife(float life) {
        return life;
    }

    public void setRenderSize(float size) {
        this.renderSize = size;
    }

    public float getRenderSize() {
        return this.renderSize;
    }

    public void setKnockBack(float knockback) {
        this.knockback = knockback;
    }
}

