/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import java.util.ArrayList;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.container.ContainerPatternMonitor;
import matteroverdrive.container.MOBaseContainer;
import matteroverdrive.data.ItemPattern;
import matteroverdrive.gui.MOGuiNetworkMachine;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementMonitorItemPattern;
import matteroverdrive.gui.element.ElementPatternsGrid;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.gui.element.MOElementTextField;
import matteroverdrive.gui.pages.PageTasks;
import matteroverdrive.network.packet.server.PacketPatternMonitorCommands;
import matteroverdrive.network.packet.server.PacketRemoveTask;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.tile.TileEntityMachinePatternMonitor;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class GuiPatternMonitor
extends MOGuiNetworkMachine<TileEntityMachinePatternMonitor> {
    MOElementButton refreshButton;
    MOElementButton requestButton;
    ElementPatternsGrid elementGrid;
    PageTasks pageTasks;
    MOElementTextField searchField;

    public GuiPatternMonitor(InventoryPlayer inventoryPlayer, TileEntityMachinePatternMonitor machine) {
        super(new ContainerPatternMonitor(inventoryPlayer, machine), machine);
        this.name = "pattern_monitor";
        this.refreshButton = new MOElementButton(this, this, 6, 45, "Refresh", 0, 0, 22, 0, 22, 22, "");
        this.refreshButton.setTexture("mo:textures/gui/items/refresh.png", 44, 22);
        this.refreshButton.setToolTip(MOStringHelper.translateToLocal("gui.tooltip.button.refresh"));
        this.requestButton = new MOElementButton(this, this, 6, 75, "Request", 0, 0, 22, 0, 22, 22, "");
        this.requestButton.setTexture("mo:textures/gui/items/request.png", 44, 22);
        this.requestButton.setToolTip(MOStringHelper.translateToLocal("gui.tooltip.button.request"));
        this.elementGrid = new ElementPatternsGrid(this, 48, 40, 160, 110);
        this.searchField = new MOElementTextField(this, 41, 26, 167, 14);
        this.slotsList.addElement(this.refreshButton);
        this.slotsList.addElement(this.requestButton);
        this.elementGrid.updateStackList(machine.getGuiPatterns());
    }

    @Override
    public void registerPages(MOBaseContainer container, TileEntityMachinePatternMonitor machine) {
        super.registerPages(container, machine);
        this.pageTasks = new PageTasks(this, 0, 0, this.field_146999_f, this.field_147000_g, machine.getTaskQueue(0));
        this.pageTasks.setName("Tasks");
        this.AddPage(this.pageTasks, ClientProxy.holoIcons.getIcon("page_icon_tasks"), MOStringHelper.translateToLocal("gui.tooltip.page.tasks")).setIconColor(Reference.COLOR_MATTER);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ((ElementBaseGroup)this.pages.get(0)).addElement(this.elementGrid);
        ((ElementBaseGroup)this.pages.get(0)).addElement(this.searchField);
        this.AddHotbarPlayerSlots(this.field_147002_h, this);
    }

    @Override
    public void handleElementButtonClick(MOElementBase element, String buttonName, int mouseButton) {
        super.handleElementButtonClick(element, buttonName, mouseButton);
        if (buttonName.equals("Refresh")) {
            MatterOverdrive.packetPipeline.sendToServer(new PacketPatternMonitorCommands((TileEntityMachinePatternMonitor)this.machine, 0, null));
        } else if (buttonName.equals("Request")) {
            ArrayList<ItemPattern> requestList = new ArrayList<ItemPattern>();
            for (int i = 0; i < this.elementGrid.getElements().size(); ++i) {
                if (!(this.elementGrid.getElements().get(i) instanceof ElementMonitorItemPattern)) continue;
                ElementMonitorItemPattern itemPattern = (ElementMonitorItemPattern)this.elementGrid.getElements().get(i);
                if (itemPattern.getAmount() > 0) {
                    ItemPattern pattern = itemPattern.getPattern().copy();
                    pattern.setCount(itemPattern.getAmount());
                    requestList.add(pattern);
                    itemPattern.setAmount(0);
                    continue;
                }
                itemPattern.setExpanded(false);
            }
            if (requestList.size() > 0) {
                MatterOverdrive.packetPipeline.sendToServer(new PacketPatternMonitorCommands((TileEntityMachinePatternMonitor)this.machine, 1, requestList));
            }
        } else if (buttonName.equals("DropTask")) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("TaskID", mouseButton);
            MatterOverdrive.packetPipeline.sendToServer(new PacketRemoveTask(this.machine, mouseButton, 0, MatterNetworkTaskState.INVALID));
        }
    }

    @Override
    protected void updateElementInformation() {
        super.updateElementInformation();
        if (((TileEntityMachinePatternMonitor)this.machine).needsRefresh()) {
            this.elementGrid.updateStackList(((TileEntityMachinePatternMonitor)this.machine).getGuiPatterns());
            ((TileEntityMachinePatternMonitor)this.machine).forceSearch(false);
        }
        this.elementGrid.setFilter(this.searchField.getText());
    }
}

