/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.container.ContainerMachine;
import matteroverdrive.container.ContainerReplicator;
import matteroverdrive.container.MOBaseContainer;
import matteroverdrive.data.ItemPattern;
import matteroverdrive.gui.GuiElementList;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.MOGuiNetworkMachine;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementDualScaled;
import matteroverdrive.gui.element.ElementInventorySlot;
import matteroverdrive.gui.element.ElementItemPattern;
import matteroverdrive.gui.element.ElementMatterStored;
import matteroverdrive.gui.element.ElementSlot;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.gui.element.MOElementEnergy;
import matteroverdrive.gui.pages.PageTasks;
import matteroverdrive.matter_network.tasks.MatterNetworkTaskReplicatePattern;
import matteroverdrive.network.packet.server.PacketRemoveTask;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.tile.TileEntityMachineReplicator;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.MatterHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class GuiReplicator
extends MOGuiNetworkMachine<TileEntityMachineReplicator> {
    MOElementEnergy energyElement;
    ElementMatterStored matterElement;
    ElementDualScaled replicate_progress;
    ElementSlot outputSlot;
    ElementSlot seccoundOutputSlot;
    PageTasks pagePackets;
    ElementItemPattern itemPattern;

    public GuiReplicator(InventoryPlayer inventoryPlayer, TileEntityMachineReplicator entity) {
        super(new ContainerReplicator(inventoryPlayer, entity), entity);
        this.name = "replicator";
        this.matterElement = new ElementMatterStored(this, 141, 39, ((TileEntityMachineReplicator)this.machine).getMatterStorage());
        this.energyElement = new MOElementEnergy(this, 167, 39, ((TileEntityMachineReplicator)this.machine).getEnergyStorage());
        this.replicate_progress = new ElementDualScaled(this, 32, 52);
        this.outputSlot = new ElementInventorySlot((MOGuiBase)this, this.getContainer().getSlotAt(((TileEntityMachineReplicator)this.machine).OUTPUT_SLOT_ID), 70, 52, 22, 22, "big");
        this.seccoundOutputSlot = new ElementInventorySlot((MOGuiBase)this, this.getContainer().getSlotAt(((TileEntityMachineReplicator)this.machine).SECOND_OUTPUT_SLOT_ID), 96, 52, 22, 22, "big");
        this.itemPattern = new ElementItemPattern((MOGuiBase)this, entity.getInternalPatternStorage(), "big_main", 37, 22);
        this.slotsList.setPosition(5, 49);
        this.slotsList.addElementAt(0, this.itemPattern);
        this.replicate_progress.setMode(1);
        this.replicate_progress.setSize(24, 16);
        this.replicate_progress.setTexture("mo:textures/gui/elements/Progress_Arrow_Right.png", 48, 16);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addElement(this.replicate_progress);
        ((ElementBaseGroup)this.pages.get(0)).addElement(this.outputSlot);
        ((ElementBaseGroup)this.pages.get(0)).addElement(this.seccoundOutputSlot);
        ((ElementBaseGroup)this.pages.get(0)).addElement(this.matterElement);
        ((ElementBaseGroup)this.pages.get(0)).addElement(this.energyElement);
        this.AddHotbarPlayerSlots(this.field_147002_h, this);
        this.AddMainPlayerSlots(this.field_147002_h, (GuiElementList)this.pages.get(0));
    }

    @Override
    public void registerPages(MOBaseContainer container, TileEntityMachineReplicator machine) {
        super.registerPages(container, machine);
        this.pagePackets = new PageTasks(this, 10, 0, this.field_146999_f, this.field_147000_g, machine.getTaskQueue(0));
        this.pagePackets.setName("Tasks");
        this.AddPage(this.pagePackets, ClientProxy.holoIcons.getIcon("page_icon_tasks"), MOStringHelper.translateToLocal("gui.tooltip.page.tasks")).setIconColor(Reference.COLOR_MATTER);
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        List list = stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
        for (int k = 0; k < list.size(); ++k) {
            String info = (String)list.get(k);
            if (k == 0) {
                list.set(k, stack.func_77953_t().field_77937_e + info);
                continue;
            }
            list.set(k, EnumChatFormatting.GRAY + info);
        }
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        this.drawHoveringText(list, x, y, font == null ? this.field_146289_q : font);
    }

    @Override
    protected void func_146976_a(float partialTick, int x, int y) {
        super.func_146976_a(partialTick, x, y);
        this.replicate_progress.setQuantity(Math.round(((ContainerMachine)this.getContainer()).getProgress() * 24.0f));
    }

    @Override
    public void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.ManageReqiremnetsTooltips();
    }

    void ManageReqiremnetsTooltips() {
        ItemPattern itemPattern = ((TileEntityMachineReplicator)this.machine).getInternalPatternStorage();
        if (itemPattern != null) {
            ItemStack item = itemPattern.toItemStack(false);
            int matterAmount = MatterHelper.getMatterAmountFromItem(item);
            this.matterElement.setDrain(-matterAmount);
            this.energyElement.setEnergyRequired(-((TileEntityMachineReplicator)this.machine).getEnergyDrainMax());
            this.energyElement.setEnergyRequiredPerTick(-((TileEntityMachineReplicator)this.machine).getEnergyDrainPerTick());
        }
    }

    @Override
    protected void updateElementInformation() {
        super.updateElementInformation();
        MatterNetworkTaskReplicatePattern task = (MatterNetworkTaskReplicatePattern)((TileEntityMachineReplicator)this.machine).getTaskQueue(0).peek();
        if (task != null && ((TileEntityMachineReplicator)this.machine).getInternalPatternStorage() != null) {
            this.itemPattern.setAmount(((ContainerReplicator)this.field_147002_h).getPatternReplicateCount());
        } else {
            this.itemPattern.setAmount(0);
        }
    }

    @Override
    public void handleElementButtonClick(MOElementBase element, String buttonName, int mouseButton) {
        super.handleElementButtonClick(element, buttonName, mouseButton);
        if (buttonName.equals("DropTask")) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("TaskID", mouseButton);
            MatterOverdrive.packetPipeline.sendToServer(new PacketRemoveTask(this.machine, mouseButton, 0, MatterNetworkTaskState.INVALID));
        }
    }
}

